/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.neo4j.bolt.connection.DatabaseName;
import org.neo4j.bolt.connection.SecurityPlan;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.BookmarkManager;
import org.neo4j.driver.Config;
import org.neo4j.driver.Logging;
import org.neo4j.driver.NotificationConfig;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.NoOpBookmarkManager;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.adaptedbolt.DriverBoltConnectionSource;
import org.neo4j.driver.internal.async.LeakLoggingNetworkSession;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.homedb.HomeDatabaseCache;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.security.BoltSecurityPlanManager;

public class SessionFactoryImpl
implements SessionFactory {
    private final BoltSecurityPlanManager securityPlanManager;
    private final DriverBoltConnectionSource connectionSource;
    private final RetryLogic retryLogic;
    private final Logging logging;
    private final boolean leakedSessionsLoggingEnabled;
    private final long defaultFetchSize;
    private final AuthTokenManager authTokenManager;
    private final HomeDatabaseCache homeDatabaseCache;

    SessionFactoryImpl(BoltSecurityPlanManager securityPlanManager, DriverBoltConnectionSource connectionSource, RetryLogic retryLogic, Config config, AuthTokenManager authTokenManager, HomeDatabaseCache homeDatabaseCache) {
        this.securityPlanManager = Objects.requireNonNull(securityPlanManager);
        this.connectionSource = connectionSource;
        this.leakedSessionsLoggingEnabled = config.logLeakedSessions();
        this.retryLogic = retryLogic;
        this.logging = config.logging();
        this.defaultFetchSize = config.fetchSize();
        this.authTokenManager = authTokenManager;
        this.homeDatabaseCache = Objects.requireNonNull(homeDatabaseCache);
    }

    @Override
    public NetworkSession newInstance(SessionConfig sessionConfig, AuthToken overrideAuthToken, boolean telemetryDisabled) {
        return this.createSession(this.securityPlanManager, this.connectionSource, this.retryLogic, this.parseDatabaseName(sessionConfig), sessionConfig.defaultAccessMode(), this.toDistinctSet(sessionConfig.bookmarks()), this.parseFetchSize(sessionConfig), sessionConfig.impersonatedUser().orElse(null), this.logging, sessionConfig.bookmarkManager().orElse(NoOpBookmarkManager.INSTANCE), sessionConfig.notificationConfig(), overrideAuthToken, telemetryDisabled, this.authTokenManager, this.homeDatabaseCache);
    }

    private Set<Bookmark> toDistinctSet(Iterable<Bookmark> bookmarks) {
        HashSet<Bookmark> set = new HashSet<Bookmark>();
        if (bookmarks != null) {
            for (Bookmark bookmark : bookmarks) {
                if (bookmark == null) continue;
                String values = bookmark.value();
                set.add(bookmark);
            }
        }
        return Collections.unmodifiableSet(set);
    }

    private long parseFetchSize(SessionConfig sessionConfig) {
        return sessionConfig.fetchSize().orElse(this.defaultFetchSize);
    }

    private DatabaseName parseDatabaseName(SessionConfig sessionConfig) {
        return sessionConfig.database().flatMap(name -> Optional.of(DatabaseName.database((String)name))).orElse(DatabaseName.defaultDatabase());
    }

    @Override
    public CompletionStage<Void> verifyConnectivity() {
        return this.connectionSource.verifyConnectivity();
    }

    @Override
    public CompletionStage<Void> close() {
        return this.connectionSource.close();
    }

    @Override
    public CompletionStage<Boolean> supportsMultiDb() {
        return this.connectionSource.supportsMultiDb();
    }

    @Override
    public CompletionStage<Boolean> supportsSessionAuth() {
        return this.connectionSource.supportsSessionAuth();
    }

    private NetworkSession createSession(BoltSecurityPlanManager securityPlanManager, DriverBoltConnectionSource connectionProvider, RetryLogic retryLogic, DatabaseName databaseName, AccessMode mode, Set<Bookmark> bookmarks, long fetchSize, String impersonatedUser, Logging logging, BookmarkManager bookmarkManager, NotificationConfig notificationConfig, AuthToken authToken, boolean telemetryDisabled, AuthTokenManager authTokenManager, HomeDatabaseCache homeDatabaseCache) {
        Objects.requireNonNull(bookmarks, "bookmarks may not be null");
        Objects.requireNonNull(bookmarkManager, "bookmarkManager may not be null");
        return this.leakedSessionsLoggingEnabled ? new LeakLoggingNetworkSession(connectionProvider, retryLogic, databaseName, mode, bookmarks, impersonatedUser, fetchSize, logging, bookmarkManager, notificationConfig, authToken, telemetryDisabled, authTokenManager, homeDatabaseCache) : new NetworkSession(connectionProvider, retryLogic, databaseName, mode, bookmarks, impersonatedUser, fetchSize, logging, bookmarkManager, notificationConfig, authToken, telemetryDisabled, authTokenManager, homeDatabaseCache);
    }

    public DriverBoltConnectionSource getConnectionSource() {
        return this.connectionSource;
    }

    private record SecurityPlanAndAuthToken(SecurityPlan securityPlan, Map<String, Value> authToken) {
    }
}

