/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value.mapping;

import java.lang.reflect.Constructor;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.value.InternalValue;
import org.neo4j.driver.internal.value.mapping.Argument;
import org.neo4j.driver.internal.value.mapping.ObjectMetadata;
import org.neo4j.driver.mapping.Property;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.Type;
import org.neo4j.driver.types.TypeSystem;

class ConstructorFinder {
    private static final TypeSystem TS = TypeSystem.getDefault();
    private static final Set<Type> ENTITY_TYPES = Set.of(TS.NODE(), TS.RELATIONSHIP());

    ConstructorFinder() {
    }

    public <T> Optional<ObjectMetadata<T>> findConstructor(MapAccessor mapAccessor, Class<T> targetClass) {
        PropertiesMatch<?> bestPropertiesMatch = null;
        Constructor<?>[] constructors = targetClass.getDeclaredConstructors();
        int propertyNamesSize = mapAccessor.size();
        for (Constructor<?> constructor : constructors) {
            PropertiesMatch<?> matchNumbers = this.matchPropertyNames(mapAccessor, constructor);
            if (bestPropertiesMatch == null || matchNumbers.match() >= bestPropertiesMatch.match() && matchNumbers.mismatch() < bestPropertiesMatch.mismatch()) {
                if (matchNumbers.isAccessible()) {
                    bestPropertiesMatch = matchNumbers;
                    if (bestPropertiesMatch.match() != propertyNamesSize || bestPropertiesMatch.mismatch() != 0) continue;
                    break;
                }
                if (!constructor.trySetAccessible()) continue;
                bestPropertiesMatch = matchNumbers;
                continue;
            }
            if (matchNumbers.match() == bestPropertiesMatch.match() && matchNumbers.mismatch() == bestPropertiesMatch.mismatch() && matchNumbers.isAccessible() && !bestPropertiesMatch.isAccessible() && (bestPropertiesMatch = matchNumbers).match() == propertyNamesSize && bestPropertiesMatch.mismatch() == 0) break;
        }
        if (bestPropertiesMatch == null || bestPropertiesMatch.match() == 0) {
            return Optional.empty();
        }
        return Optional.of(new ObjectMetadata(bestPropertiesMatch.constructor(), bestPropertiesMatch.arguments()));
    }

    private <T> PropertiesMatch<T> matchPropertyNames(MapAccessor mapAccessor, Constructor<T> constructor) {
        int match = 0;
        int mismatch = 0;
        Parameter[] parameters = constructor.getParameters();
        ArrayList<Argument> arguments = new ArrayList<Argument>(parameters.length);
        for (Parameter parameter : parameters) {
            String propertyName;
            Property propertyNameAnnotation = parameter.getAnnotation(Property.class);
            String string = propertyName = propertyNameAnnotation != null ? propertyNameAnnotation.value() : parameter.getName();
            if (this.contains(mapAccessor, propertyName)) {
                ++match;
            } else {
                ++mismatch;
            }
            arguments.add(new Argument(propertyName, parameter.getParameterizedType(), (InternalValue)mapAccessor.get(propertyName)));
        }
        return new PropertiesMatch<T>(match, mismatch, constructor, arguments, this.isAccessible(constructor));
    }

    private boolean contains(MapAccessor mapAccessor, String propertyName) {
        if (mapAccessor instanceof Value) {
            Value value = (Value)mapAccessor;
            if (ENTITY_TYPES.contains(value.type())) {
                return value.asEntity().containsKey(propertyName);
            }
            return mapAccessor.containsKey(propertyName);
        }
        return mapAccessor.containsKey(propertyName);
    }

    private boolean isAccessible(Constructor<?> constructor) {
        try {
            return constructor.canAccess(null);
        }
        catch (Exception e) {
            return false;
        }
    }

    private record PropertiesMatch<T>(int match, int mismatch, Constructor<T> constructor, List<Argument> arguments, boolean isAccessible) {
    }
}

