/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.time.Clock;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.async.ConnectionContext;
import org.neo4j.driver.internal.cluster.ClusterCompositionLookupResult;
import org.neo4j.driver.internal.cluster.ClusterRoutingTable;
import org.neo4j.driver.internal.cluster.Rediscovery;
import org.neo4j.driver.internal.cluster.RoutingTableHandler;
import org.neo4j.driver.internal.cluster.RoutingTableHandlerImpl;
import org.neo4j.driver.internal.cluster.RoutingTableRegistry;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.util.Futures;

public class RoutingTableRegistryImpl
implements RoutingTableRegistry {
    private final ConcurrentMap<DatabaseName, RoutingTableHandler> routingTableHandlers;
    private final Map<Principal, CompletionStage<DatabaseName>> principalToDatabaseNameStage;
    private final RoutingTableHandlerFactory factory;
    private final Logger log;
    private final Clock clock;
    private final ConnectionPool connectionPool;
    private final Rediscovery rediscovery;

    public RoutingTableRegistryImpl(ConnectionPool connectionPool, Rediscovery rediscovery, Clock clock, Logging logging, long routingTablePurgeDelayMs) {
        this(new ConcurrentHashMap<DatabaseName, RoutingTableHandler>(), new RoutingTableHandlerFactory(connectionPool, rediscovery, clock, logging, routingTablePurgeDelayMs), clock, connectionPool, rediscovery, logging);
    }

    RoutingTableRegistryImpl(ConcurrentMap<DatabaseName, RoutingTableHandler> routingTableHandlers, RoutingTableHandlerFactory factory, Clock clock, ConnectionPool connectionPool, Rediscovery rediscovery, Logging logging) {
        Objects.requireNonNull(rediscovery, "rediscovery must not be null");
        this.factory = factory;
        this.routingTableHandlers = routingTableHandlers;
        this.principalToDatabaseNameStage = new HashMap<Principal, CompletionStage<DatabaseName>>();
        this.clock = clock;
        this.connectionPool = connectionPool;
        this.rediscovery = rediscovery;
        this.log = logging.getLog(this.getClass());
    }

    @Override
    public CompletionStage<RoutingTableHandler> ensureRoutingTable(ConnectionContext context) {
        return this.ensureDatabaseNameIsCompleted(context).thenCompose(ctxAndHandler -> {
            ConnectionContext completedContext = ctxAndHandler.getContext();
            RoutingTableHandler handler = ctxAndHandler.getHandler() != null ? ctxAndHandler.getHandler() : this.getOrCreate(Futures.joinNowOrElseThrow(completedContext.databaseNameFuture(), ConnectionContext.PENDING_DATABASE_NAME_EXCEPTION_SUPPLIER));
            return handler.ensureRoutingTable(completedContext).thenApply(ignored -> handler);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<ConnectionContextAndHandler> ensureDatabaseNameIsCompleted(ConnectionContext context) {
        CompletionStage<ConnectionContextAndHandler> contextAndHandlerStage;
        CompletableFuture<DatabaseName> contextDatabaseNameFuture = context.databaseNameFuture();
        if (contextDatabaseNameFuture.isDone()) {
            contextAndHandlerStage = CompletableFuture.completedFuture(new ConnectionContextAndHandler(context, null));
        } else {
            RoutingTableRegistryImpl routingTableRegistryImpl = this;
            synchronized (routingTableRegistryImpl) {
                if (contextDatabaseNameFuture.isDone()) {
                    contextAndHandlerStage = CompletableFuture.completedFuture(new ConnectionContextAndHandler(context, null));
                } else {
                    String impersonatedUser = context.impersonatedUser();
                    Principal principal = new Principal(impersonatedUser);
                    CompletionStage<DatabaseName> databaseNameStage = this.principalToDatabaseNameStage.get(principal);
                    AtomicReference handlerRef = new AtomicReference();
                    if (databaseNameStage == null) {
                        CompletableFuture<DatabaseName> databaseNameFuture = new CompletableFuture<DatabaseName>();
                        this.principalToDatabaseNameStage.put(principal, databaseNameFuture);
                        databaseNameStage = databaseNameFuture;
                        ClusterRoutingTable routingTable = new ClusterRoutingTable(DatabaseNameUtil.defaultDatabase(), this.clock, new BoltServerAddress[0]);
                        this.rediscovery.lookupClusterComposition(routingTable, this.connectionPool, context.rediscoveryBookmarks(), impersonatedUser, context.overrideAuthToken()).thenCompose(compositionLookupResult -> {
                            DatabaseName databaseName = DatabaseNameUtil.database(compositionLookupResult.getClusterComposition().databaseName());
                            RoutingTableHandler handler = this.getOrCreate(databaseName);
                            handlerRef.set(handler);
                            return handler.updateRoutingTable((ClusterCompositionLookupResult)compositionLookupResult).thenApply(ignored -> databaseName);
                        }).whenComplete((databaseName, throwable) -> {
                            RoutingTableRegistryImpl routingTableRegistryImpl = this;
                            synchronized (routingTableRegistryImpl) {
                                this.principalToDatabaseNameStage.remove(principal);
                            }
                        }).whenComplete((databaseName, throwable) -> {
                            if (throwable != null) {
                                databaseNameFuture.completeExceptionally((Throwable)throwable);
                            } else {
                                databaseNameFuture.complete((DatabaseName)databaseName);
                            }
                        });
                    }
                    contextAndHandlerStage = databaseNameStage.thenApply(databaseName -> {
                        RoutingTableRegistryImpl routingTableRegistryImpl = this;
                        synchronized (routingTableRegistryImpl) {
                            contextDatabaseNameFuture.complete((DatabaseName)databaseName);
                        }
                        return new ConnectionContextAndHandler(context, (RoutingTableHandler)handlerRef.get());
                    });
                }
            }
        }
        return contextAndHandlerStage;
    }

    @Override
    public Set<BoltServerAddress> allServers() {
        HashSet<BoltServerAddress> servers = new HashSet<BoltServerAddress>();
        for (RoutingTableHandler tableHandler : this.routingTableHandlers.values()) {
            servers.addAll(tableHandler.servers());
        }
        return servers;
    }

    @Override
    public void remove(DatabaseName databaseName) {
        this.routingTableHandlers.remove(databaseName);
        this.log.debug("Routing table handler for database '%s' is removed.", databaseName.description());
    }

    @Override
    public void removeAged() {
        this.routingTableHandlers.forEach((databaseName, handler) -> {
            if (handler.isRoutingTableAged()) {
                this.log.info("Routing table handler for database '%s' is removed because it has not been used for a long time. Routing table: %s", databaseName.description(), handler.routingTable());
                this.routingTableHandlers.remove(databaseName);
            }
        });
    }

    @Override
    public Optional<RoutingTableHandler> getRoutingTableHandler(DatabaseName databaseName) {
        return Optional.ofNullable((RoutingTableHandler)this.routingTableHandlers.get(databaseName));
    }

    public boolean contains(DatabaseName databaseName) {
        return this.routingTableHandlers.containsKey(databaseName);
    }

    private RoutingTableHandler getOrCreate(DatabaseName databaseName) {
        return this.routingTableHandlers.computeIfAbsent(databaseName, name -> {
            RoutingTableHandler handler = this.factory.newInstance((DatabaseName)name, this);
            this.log.debug("Routing table handler for database '%s' is added.", databaseName.description());
            return handler;
        });
    }

    static class RoutingTableHandlerFactory {
        private final ConnectionPool connectionPool;
        private final Rediscovery rediscovery;
        private final Logging logging;
        private final Clock clock;
        private final long routingTablePurgeDelayMs;

        RoutingTableHandlerFactory(ConnectionPool connectionPool, Rediscovery rediscovery, Clock clock, Logging logging, long routingTablePurgeDelayMs) {
            this.connectionPool = connectionPool;
            this.rediscovery = rediscovery;
            this.clock = clock;
            this.logging = logging;
            this.routingTablePurgeDelayMs = routingTablePurgeDelayMs;
        }

        RoutingTableHandler newInstance(DatabaseName databaseName, RoutingTableRegistry allTables) {
            ClusterRoutingTable routingTable = new ClusterRoutingTable(databaseName, this.clock, new BoltServerAddress[0]);
            return new RoutingTableHandlerImpl(routingTable, this.rediscovery, this.connectionPool, allTables, this.logging, this.routingTablePurgeDelayMs);
        }
    }

    private static class ConnectionContextAndHandler {
        private final ConnectionContext context;
        private final RoutingTableHandler handler;

        private ConnectionContextAndHandler(ConnectionContext context, RoutingTableHandler handler) {
            this.context = context;
            this.handler = handler;
        }

        public ConnectionContext getContext() {
            return this.context;
        }

        public RoutingTableHandler getHandler() {
            return this.handler;
        }
    }

    private static class Principal {
        private final String id;

        private Principal(String id) {
            this.id = id;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Principal principal = (Principal)o;
            return Objects.equals(this.id, principal.id);
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }
    }
}

