/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.BookmarkManager;
import org.neo4j.driver.NotificationConfig;
import org.neo4j.driver.internal.handlers.pulln.FetchSizeUtil;
import org.neo4j.driver.util.Preview;

public final class SessionConfig
implements Serializable {
    private static final long serialVersionUID = 5773462156979050657L;
    private static final SessionConfig EMPTY = SessionConfig.builder().build();
    private final Iterable<Bookmark> bookmarks;
    private final AccessMode defaultAccessMode;
    private final String database;
    private final Long fetchSize;
    private final String impersonatedUser;
    private final BookmarkManager bookmarkManager;
    private final NotificationConfig notificationConfig;

    private SessionConfig(Builder builder) {
        this.bookmarks = builder.bookmarks;
        this.defaultAccessMode = builder.defaultAccessMode;
        this.database = builder.database;
        this.fetchSize = builder.fetchSize;
        this.impersonatedUser = builder.impersonatedUser;
        this.bookmarkManager = builder.bookmarkManager;
        this.notificationConfig = builder.notificationConfig;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static SessionConfig defaultConfig() {
        return EMPTY;
    }

    public static SessionConfig forDatabase(String database) {
        return new Builder().withDatabase(database).build();
    }

    public Iterable<Bookmark> bookmarks() {
        return this.bookmarks;
    }

    public AccessMode defaultAccessMode() {
        return this.defaultAccessMode;
    }

    public Optional<String> database() {
        return Optional.ofNullable(this.database);
    }

    public Optional<Long> fetchSize() {
        return Optional.ofNullable(this.fetchSize);
    }

    public Optional<String> impersonatedUser() {
        return Optional.ofNullable(this.impersonatedUser);
    }

    @Preview(name="Bookmark Manager")
    public Optional<BookmarkManager> bookmarkManager() {
        return Optional.ofNullable(this.bookmarkManager);
    }

    public NotificationConfig notificationConfig() {
        return this.notificationConfig;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionConfig that = (SessionConfig)o;
        return Objects.equals(this.bookmarks, that.bookmarks) && this.defaultAccessMode == that.defaultAccessMode && Objects.equals(this.database, that.database) && Objects.equals(this.fetchSize, that.fetchSize) && Objects.equals(this.impersonatedUser, that.impersonatedUser) && Objects.equals(this.bookmarkManager, that.bookmarkManager) && Objects.equals(this.notificationConfig, that.notificationConfig);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.bookmarks, this.defaultAccessMode, this.database, this.impersonatedUser, this.bookmarkManager});
    }

    public String toString() {
        return String.format("SessionParameters{bookmarks=%s, defaultAccessMode=%s, database='%s', fetchSize=%d, impersonatedUser=%s, bookmarkManager=%s}", new Object[]{this.bookmarks, this.defaultAccessMode, this.database, this.fetchSize, this.impersonatedUser, this.bookmarkManager});
    }

    public static final class Builder {
        private Long fetchSize = null;
        private Iterable<Bookmark> bookmarks = null;
        private AccessMode defaultAccessMode = AccessMode.WRITE;
        private String database = null;
        private String impersonatedUser = null;
        private BookmarkManager bookmarkManager;
        private NotificationConfig notificationConfig = NotificationConfig.defaultConfig();

        private Builder() {
        }

        public Builder withBookmarks(Bookmark ... bookmarks) {
            this.bookmarks = bookmarks == null ? null : Arrays.asList(bookmarks);
            return this;
        }

        public Builder withBookmarks(Iterable<Bookmark> bookmarks) {
            this.bookmarks = bookmarks;
            return this;
        }

        public Builder withDefaultAccessMode(AccessMode mode) {
            this.defaultAccessMode = mode;
            return this;
        }

        public Builder withDatabase(String database) {
            Objects.requireNonNull(database, "Database name should not be null.");
            if (database.isEmpty()) {
                throw new IllegalArgumentException(String.format("Illegal database name '%s'.", database));
            }
            this.database = database;
            return this;
        }

        public Builder withFetchSize(long size) {
            this.fetchSize = FetchSizeUtil.assertValidFetchSize(size);
            return this;
        }

        public Builder withImpersonatedUser(String impersonatedUser) {
            Objects.requireNonNull(impersonatedUser, "Impersonated user should not be null.");
            if (impersonatedUser.isEmpty()) {
                throw new IllegalArgumentException(String.format("Illegal impersonated user '%s'.", impersonatedUser));
            }
            this.impersonatedUser = impersonatedUser;
            return this;
        }

        @Preview(name="Bookmark Manager")
        public Builder withBookmarkManager(BookmarkManager bookmarkManager) {
            this.bookmarkManager = bookmarkManager;
            return this;
        }

        public Builder withNotificationConfig(NotificationConfig notificationConfig) {
            this.notificationConfig = Objects.requireNonNull(notificationConfig, "notificationConfig must not be null");
            return this;
        }

        public SessionConfig build() {
            return new SessionConfig(this);
        }
    }
}

