/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.util.concurrent.CompletionStage;
import org.neo4j.driver.BaseSession;
import org.neo4j.driver.BookmarkManager;
import org.neo4j.driver.Metrics;
import org.neo4j.driver.QueryTask;
import org.neo4j.driver.Session;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.async.AsyncSession;
import org.neo4j.driver.reactive.ReactiveSession;
import org.neo4j.driver.reactive.RxSession;
import org.neo4j.driver.types.TypeSystem;
import org.neo4j.driver.util.Experimental;

public interface Driver
extends AutoCloseable {
    @Experimental
    public QueryTask queryTask(String var1);

    @Experimental
    public BookmarkManager queryBookmarkManager();

    public boolean isEncrypted();

    default public Session session() {
        return this.session(Session.class);
    }

    default public Session session(SessionConfig sessionConfig) {
        return this.session(Session.class, sessionConfig);
    }

    default public <T extends BaseSession> T session(Class<T> sessionClass) {
        return this.session(sessionClass, SessionConfig.defaultConfig());
    }

    public <T extends BaseSession> T session(Class<T> var1, SessionConfig var2);

    @Deprecated
    default public RxSession rxSession() {
        return this.session(RxSession.class);
    }

    @Deprecated
    default public RxSession rxSession(SessionConfig sessionConfig) {
        return this.session(RxSession.class, sessionConfig);
    }

    @Deprecated
    default public ReactiveSession reactiveSession() {
        return this.session(ReactiveSession.class);
    }

    @Deprecated
    default public ReactiveSession reactiveSession(SessionConfig sessionConfig) {
        return this.session(ReactiveSession.class, sessionConfig);
    }

    @Deprecated
    default public AsyncSession asyncSession() {
        return this.session(AsyncSession.class);
    }

    @Deprecated
    default public AsyncSession asyncSession(SessionConfig sessionConfig) {
        return this.session(AsyncSession.class, sessionConfig);
    }

    @Override
    public void close();

    public CompletionStage<Void> closeAsync();

    public Metrics metrics();

    public boolean isMetricsEnabled();

    @Experimental
    public TypeSystem defaultTypeSystem();

    public void verifyConnectivity();

    public CompletionStage<Void> verifyConnectivityAsync();

    public boolean supportsMultiDb();

    public CompletionStage<Boolean> supportsMultiDbAsync();
}

