/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.Optional;
import org.neo4j.bolt.connection.BoltAgent;
import org.neo4j.driver.Session;

public class DriverInfoUtil {
    public static BoltAgent boltAgent() {
        String productInfo = String.format("neo4j-java/%s", DriverInfoUtil.driverVersion());
        StringBuilder platformBuilder = new StringBuilder();
        DriverInfoUtil.getProperty("os.name").ifPresent(value -> DriverInfoUtil.append(value, platformBuilder));
        DriverInfoUtil.getProperty("os.version").ifPresent(value -> DriverInfoUtil.append(value, platformBuilder));
        DriverInfoUtil.getProperty("os.arch").ifPresent(value -> DriverInfoUtil.append(value, platformBuilder));
        Optional<String> language = DriverInfoUtil.getProperty("java.version").map(version -> "Java/" + version);
        Optional<StringBuilder> languageDetails = language.map(ignored -> {
            StringBuilder languageDetailsBuilder = new StringBuilder();
            DriverInfoUtil.getProperty("java.vm.vendor").ifPresent(value -> DriverInfoUtil.append(value, languageDetailsBuilder));
            DriverInfoUtil.getProperty("java.vm.name").ifPresent(value -> DriverInfoUtil.append(value, languageDetailsBuilder));
            DriverInfoUtil.getProperty("java.vm.version").ifPresent(value -> DriverInfoUtil.append(value, languageDetailsBuilder));
            return languageDetailsBuilder.isEmpty() ? null : languageDetailsBuilder;
        });
        return new BoltAgent(productInfo, platformBuilder.isEmpty() ? null : platformBuilder.toString(), (String)language.orElse(null), (String)languageDetails.map(StringBuilder::toString).orElse(null));
    }

    public static String driverVersion() {
        Package pkg = Session.class.getPackage();
        if (pkg != null && pkg.getImplementationVersion() != null) {
            return pkg.getImplementationVersion();
        }
        return "dev";
    }

    private static Optional<String> getProperty(String key) {
        try {
            String value = System.getProperty(key);
            if (value != null) {
                value = value.trim();
            }
            return value != null && !value.isEmpty() ? Optional.of(value) : Optional.empty();
        }
        catch (SecurityException exception) {
            return Optional.empty();
        }
    }

    private static void append(String value, StringBuilder builder) {
        if (value != null && !value.isEmpty()) {
            String separator = builder.isEmpty() ? "" : "; ";
            builder.append(separator).append(value);
        }
    }
}

