/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.bolt.connection.values.IsoDuration;
import org.neo4j.bolt.connection.values.Point;
import org.neo4j.bolt.connection.values.Vector;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.value.Uncoercible;
import org.neo4j.driver.internal.AsValue;
import org.neo4j.driver.internal.types.TypeConstructor;

public interface InternalValue
extends Value,
AsValue,
org.neo4j.bolt.connection.values.Value {
    public TypeConstructor typeConstructor();

    default public Object as(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return this.as(parameterizedType);
        }
        if (type instanceof Class) {
            Class classType = (Class)type;
            return this.as(classType);
        }
        throw new Uncoercible(this.type().name(), type.toString());
    }

    default public Object as(ParameterizedType type) {
        throw new Uncoercible(this.type().name(), type.toString());
    }

    default public org.neo4j.bolt.connection.values.Value getBoltValue(String key) {
        return (org.neo4j.bolt.connection.values.Value)this.get(key);
    }

    default public IsoDuration asBoltIsoDuration() {
        return (IsoDuration)this.asIsoDuration();
    }

    default public Point asBoltPoint() {
        return (Point)this.asPoint();
    }

    default public Iterable<org.neo4j.bolt.connection.values.Value> boltValues() {
        Iterable<Value> values = this.values();
        return () -> {
            final Iterator iterator = values.iterator();
            return new Iterator<org.neo4j.bolt.connection.values.Value>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public org.neo4j.bolt.connection.values.Value next() {
                    Value next = (Value)iterator.next();
                    return next != null ? (org.neo4j.bolt.connection.values.Value)next : null;
                }
            };
        };
    }

    default public Map<String, org.neo4j.bolt.connection.values.Value> asBoltMap() {
        return this.asMap((Value value) -> (org.neo4j.bolt.connection.values.Value)value);
    }

    default public Vector asBoltVector() {
        throw new UnsupportedOperationException("Vector is not supported");
    }
}

