/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.value;

import org.neo4j.bolt.connection.values.Type;
import org.neo4j.driver.exceptions.value.LossyCoercion;
import org.neo4j.driver.exceptions.value.Uncoercible;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.value.NumberValueAdapter;

public class IntegerValue
extends NumberValueAdapter<Long> {
    private final long val;

    public IntegerValue(long val) {
        this.val = val;
    }

    @Override
    public org.neo4j.driver.types.Type type() {
        return InternalTypeSystem.TYPE_SYSTEM.INTEGER();
    }

    public Type boltValueType() {
        return Type.INTEGER;
    }

    @Override
    public Long asNumber() {
        return this.val;
    }

    @Override
    public long asLong() {
        return this.val;
    }

    @Override
    public int asInt() {
        if (this.val > Integer.MAX_VALUE || this.val < Integer.MIN_VALUE) {
            throw new LossyCoercion(this.type().name(), "Java int");
        }
        return (int)this.val;
    }

    @Override
    public double asDouble() {
        double doubleVal = this.val;
        if ((long)doubleVal != this.val) {
            throw new LossyCoercion(this.type().name(), "Java double");
        }
        return this.val;
    }

    @Override
    public float asFloat() {
        return this.val;
    }

    @Override
    public <T> T as(Class<T> targetClass) {
        if (targetClass.equals(Long.TYPE)) {
            return (T)Long.valueOf(this.asLong());
        }
        if (targetClass.isAssignableFrom(Long.class)) {
            return targetClass.cast(this.asLong());
        }
        if (targetClass.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(this.asInt());
        }
        if (targetClass.equals(Integer.class)) {
            return targetClass.cast(this.asInt());
        }
        if (targetClass.equals(Double.TYPE)) {
            return (T)Double.valueOf(this.asDouble());
        }
        if (targetClass.equals(Double.class)) {
            return targetClass.cast(this.asDouble());
        }
        if (targetClass.equals(Float.TYPE)) {
            return (T)Float.valueOf(this.asFloat());
        }
        if (targetClass.equals(Float.class)) {
            return targetClass.cast(Float.valueOf(this.asFloat()));
        }
        if (targetClass.equals(Short.TYPE)) {
            return (T)Short.valueOf(this.asShort());
        }
        if (targetClass.equals(Short.class)) {
            return targetClass.cast(this.asShort());
        }
        throw new Uncoercible(this.type().name(), targetClass.getCanonicalName());
    }

    private short asShort() {
        if (this.val > 32767L || this.val < -32768L) {
            throw new LossyCoercion(this.type().name(), "Java short");
        }
        return (short)this.val;
    }

    @Override
    public String toString() {
        return Long.toString(this.val);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegerValue values = (IntegerValue)o;
        return this.val == values.val;
    }

    @Override
    public int hashCode() {
        return (int)(this.val ^ this.val >>> 32);
    }
}

