/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.bolt.connection.AccessMode;
import org.neo4j.bolt.connection.DatabaseName;
import org.neo4j.bolt.connection.NotificationConfig;
import org.neo4j.bolt.connection.TransactionType;
import org.neo4j.bolt.connection.message.BeginMessage;
import org.neo4j.bolt.connection.message.Message;
import org.neo4j.bolt.connection.message.Messages;
import org.neo4j.bolt.connection.message.PullMessage;
import org.neo4j.bolt.connection.summary.BeginSummary;
import org.neo4j.bolt.connection.summary.CommitSummary;
import org.neo4j.bolt.connection.summary.RollbackSummary;
import org.neo4j.bolt.connection.summary.RunSummary;
import org.neo4j.bolt.connection.summary.TelemetrySummary;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Logging;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.exceptions.TransactionTerminatedException;
import org.neo4j.driver.internal.DatabaseBookmark;
import org.neo4j.driver.internal.GqlStatusError;
import org.neo4j.driver.internal.adaptedbolt.BasicResponseHandler;
import org.neo4j.driver.internal.adaptedbolt.DriverBoltConnection;
import org.neo4j.driver.internal.adaptedbolt.DriverResponseHandler;
import org.neo4j.driver.internal.async.ResultCursorsHolder;
import org.neo4j.driver.internal.async.TerminationAwareBoltConnection;
import org.neo4j.driver.internal.async.TerminationAwareStateLockingExecutor;
import org.neo4j.driver.internal.cursor.DisposableResultCursorImpl;
import org.neo4j.driver.internal.cursor.ResultCursorImpl;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.cursor.RxResultCursorImpl;
import org.neo4j.driver.internal.telemetry.ApiTelemetryWork;
import org.neo4j.driver.internal.util.ErrorUtil;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.LockUtil;

public class UnmanagedTransaction
implements TerminationAwareStateLockingExecutor {
    public static final String EXPLICITLY_TERMINATED_MSG = "The transaction has been explicitly terminated by the driver";
    protected static final String CANT_COMMIT_COMMITTED_MSG = "Can't commit, transaction has been committed";
    protected static final String CANT_ROLLBACK_COMMITTED_MSG = "Can't rollback, transaction has been committed";
    protected static final String CANT_COMMIT_ROLLED_BACK_MSG = "Can't commit, transaction has been rolled back";
    protected static final String CANT_ROLLBACK_ROLLED_BACK_MSG = "Can't rollback, transaction has been rolled back";
    protected static final String CANT_COMMIT_ROLLING_BACK_MSG = "Can't commit, transaction has been requested to be rolled back";
    protected static final String CANT_ROLLBACK_COMMITTING_MSG = "Can't rollback, transaction has been requested to be committed";
    private static final EnumSet<State> OPEN_STATES = EnumSet.of(State.ACTIVE, State.TERMINATED);
    private final Logging logging;
    private final TerminationAwareBoltConnection connection;
    private final Consumer<DatabaseBookmark> bookmarkConsumer;
    private final ResultCursorsHolder resultCursors;
    private final long fetchSize;
    private final Lock lock = new ReentrantLock();
    private State state = State.ACTIVE;
    private CompletableFuture<Void> commitFuture;
    private CompletableFuture<Void> rollbackFuture;
    private Throwable causeOfTermination;
    private CompletionStage<Void> terminationStage;
    private final NotificationConfig notificationConfig;
    private final CompletableFuture<UnmanagedTransaction> beginFuture = new CompletableFuture();
    private final DatabaseName databaseName;
    private final AccessMode accessMode;
    private final String impersonatedUser;
    private final ApiTelemetryWork apiTelemetryWork;
    private final Consumer<String> databaseNameConsumer;
    private Message[] beginMessages;

    public UnmanagedTransaction(DriverBoltConnection connection, DatabaseName databaseName, AccessMode accessMode, String impersonatedUser, Consumer<DatabaseBookmark> bookmarkConsumer, long fetchSize, NotificationConfig notificationConfig, ApiTelemetryWork apiTelemetryWork, Consumer<String> databaseNameConsumer, Logging logging) {
        this(connection, databaseName, accessMode, impersonatedUser, bookmarkConsumer, fetchSize, new ResultCursorsHolder(), notificationConfig, apiTelemetryWork, databaseNameConsumer, logging);
    }

    protected UnmanagedTransaction(DriverBoltConnection connection, DatabaseName databaseName, AccessMode accessMode, String impersonatedUser, Consumer<DatabaseBookmark> bookmarkConsumer, long fetchSize, ResultCursorsHolder resultCursors, NotificationConfig notificationConfig, ApiTelemetryWork apiTelemetryWork, Consumer<String> databaseNameConsumer, Logging logging) {
        this.logging = logging;
        this.connection = new TerminationAwareBoltConnection(logging, connection, this, this::markTerminated);
        this.databaseName = databaseName;
        this.accessMode = accessMode;
        this.impersonatedUser = impersonatedUser;
        this.bookmarkConsumer = bookmarkConsumer;
        this.resultCursors = resultCursors;
        this.fetchSize = fetchSize;
        this.notificationConfig = notificationConfig;
        this.apiTelemetryWork = apiTelemetryWork;
        this.databaseNameConsumer = Objects.requireNonNull(databaseNameConsumer);
    }

    public CompletionStage<UnmanagedTransaction> beginAsync(Set<Bookmark> initialBookmarks, TransactionConfig config, String txType, boolean flush) {
        Set bookmarks = initialBookmarks.stream().map(Bookmark::value).collect(Collectors.toSet());
        return CompletableFuture.completedStage(null).thenApply(ignored -> {
            ArrayList<BeginMessage> messages = new ArrayList<BeginMessage>(2);
            this.apiTelemetryWork.getTelemetryMessageIfEnabled(this.connection).ifPresent(messages::add);
            messages.add(Messages.beginTransaction((String)this.databaseName.databaseName().orElse(null), (AccessMode)this.accessMode, (String)this.impersonatedUser, (Set)bookmarks, (TransactionType)UnmanagedTransaction.mapToTransactionType(txType), (Duration)config.timeout(), this.connection.valueFactory().toBoltMap(config.metadata()), (NotificationConfig)this.notificationConfig));
            return messages;
        }).thenCompose(messages -> {
            if (flush) {
                BeginResponseHandler responseHandler = new BeginResponseHandler(this.apiTelemetryWork, this.databaseNameConsumer);
                this.connection.writeAndFlush((DriverResponseHandler)responseHandler, (List<Message>)messages).thenCompose(ignored -> responseHandler.summaryFuture).whenComplete((summary, throwable) -> {
                    if (throwable != null) {
                        this.connection.close().whenComplete((ignored, closeThrowable) -> {
                            if (closeThrowable != null && throwable != closeThrowable) {
                                throwable.addSuppressed((Throwable)closeThrowable);
                            }
                            this.beginFuture.completeExceptionally((Throwable)throwable);
                        });
                    } else {
                        this.beginFuture.complete(this);
                    }
                });
                return this.beginFuture.thenApply(ignored -> this);
            }
            return this.connection.write((List<Message>)messages).thenApply(ignored -> this).whenComplete((ignored, throwable) -> {
                if (throwable != null) {
                    this.beginFuture.completeExceptionally((Throwable)throwable);
                } else {
                    this.beginFuture.complete(this);
                }
            });
        });
    }

    public CompletionStage<Void> closeAsync() {
        return this.closeAsync(false);
    }

    public CompletionStage<Void> closeAsync(boolean commit) {
        return this.closeAsync(commit, true);
    }

    public CompletionStage<Void> commitAsync() {
        return this.closeAsync(true, false);
    }

    public CompletionStage<Void> rollbackAsync() {
        return this.closeAsync(false, false);
    }

    public CompletionStage<ResultCursor> runAsync(Query query) {
        this.ensureCanRunQueries();
        Map<String, Value> parameters = query.parameters().asMap(Values::value);
        ResultCursorImpl resultCursor = new ResultCursorImpl(this.connection, query, this.fetchSize, bookmark -> {}, false, this.beginFuture, this.databaseNameConsumer, this.apiTelemetryWork);
        CompletionStage flushStage = CompletableFuture.completedStage(null).thenCompose(ignored -> {
            List<PullMessage> messages = List.of(Messages.run((String)query.text(), this.connection.valueFactory().toBoltMap(parameters)), Messages.pull((long)-1L, (long)this.fetchSize));
            return this.connection.writeAndFlush((DriverResponseHandler)resultCursor, messages);
        });
        return this.beginFuture.thenCompose(ignored -> {
            CompletionStage<DisposableResultCursorImpl> cursorStage = flushStage.thenCompose(flushResult -> resultCursor.resultCursor()).thenApply(DisposableResultCursorImpl::new);
            this.resultCursors.add(cursorStage);
            return cursorStage.thenApply(Function.identity());
        });
    }

    public CompletionStage<RxResultCursor> runRx(Query query) {
        this.ensureCanRunQueries();
        Map<String, Value> parameters = query.parameters().asMap(Values::value);
        RunRxResponseHandler responseHandler = new RunRxResponseHandler(this.logging, this.apiTelemetryWork, this.beginFuture, this.connection, query);
        CompletionStage flushStage = CompletableFuture.completedStage(null).thenCompose(runMessage -> this.connection.writeAndFlush((DriverResponseHandler)responseHandler, (Message)Messages.run((String)query.text(), this.connection.valueFactory().toBoltMap(parameters))));
        return this.beginFuture.thenCompose(ignored -> {
            CompletionStage cursorStage = flushStage.thenCompose(flushResult -> responseHandler.cursorFuture);
            this.resultCursors.add(cursorStage);
            return cursorStage.thenApply(Function.identity());
        });
    }

    public boolean isOpen() {
        return OPEN_STATES.contains((Object)LockUtil.executeWithLock(this.lock, () -> this.state));
    }

    public void markTerminated(Throwable cause) {
        Throwable throwable = Futures.completionExceptionCause(cause);
        LockUtil.executeWithLock(this.lock, () -> {
            if (this.isOpen() && this.commitFuture == null && this.rollbackFuture == null) {
                if (this.state == State.TERMINATED) {
                    if (throwable != null) {
                        this.addSuppressedWhenNotCaptured(this.causeOfTermination, throwable);
                    }
                } else {
                    this.state = State.TERMINATED;
                    this.causeOfTermination = throwable != null ? throwable : new TransactionTerminatedException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(EXPLICITLY_TERMINATED_MSG), "N/A", EXPLICITLY_TERMINATED_MSG, GqlStatusError.DIAGNOSTIC_RECORD, null);
                }
            }
        });
    }

    public DriverBoltConnection connection() {
        return this.connection;
    }

    private void addSuppressedWhenNotCaptured(Throwable currentCause, Throwable newCause) {
        boolean noneMatch;
        if (currentCause != newCause && (noneMatch = Arrays.stream(currentCause.getSuppressed()).noneMatch(suppressed -> suppressed == newCause))) {
            currentCause.addSuppressed(newCause);
        }
    }

    public CompletionStage<Void> terminateAsync() {
        return LockUtil.executeWithLock(this.lock, () -> {
            if (!this.isOpen() || this.commitFuture != null || this.rollbackFuture != null) {
                String message = "Can't terminate closed or closing transaction";
                return CompletableFuture.failedFuture(new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null));
            }
            if (this.state == State.TERMINATED) {
                return this.terminationStage != null ? this.terminationStage : CompletableFuture.completedFuture(null);
            }
            this.markTerminated(null);
            this.terminationStage = this.connection.reset();
            return this.terminationStage;
        });
    }

    @Override
    public <T> T execute(Function<Throwable, T> causeOfTerminationConsumer) {
        return (T)LockUtil.executeWithLock(this.lock, () -> {
            TransactionTerminatedException throwable = this.causeOfTermination == null ? null : UnmanagedTransaction.failedTxException(this.causeOfTermination);
            return causeOfTerminationConsumer.apply(throwable);
        });
    }

    private void ensureCanRunQueries() {
        LockUtil.executeWithLock(this.lock, () -> {
            if (this.state == State.COMMITTED) {
                String message = "Cannot run more queries in this transaction, it has been committed";
                throw new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null);
            }
            if (this.state == State.ROLLED_BACK) {
                String message = "Cannot run more queries in this transaction, it has been rolled back";
                throw new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null);
            }
            if (this.state == State.TERMINATED) {
                Throwable patt17184$temp = this.causeOfTermination;
                if (patt17184$temp instanceof TransactionTerminatedException) {
                    TransactionTerminatedException transactionTerminatedException = (TransactionTerminatedException)patt17184$temp;
                    throw transactionTerminatedException;
                }
                throw UnmanagedTransaction.failedTxException(this.causeOfTermination);
            }
            if (this.commitFuture != null) {
                String message = "Cannot run more queries in this transaction, it is being committed";
                throw new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null);
            }
            if (this.rollbackFuture != null) {
                String message = "Cannot run more queries in this transaction, it is being rolled back";
                throw new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null);
            }
        });
    }

    private CompletionStage<Void> doCommitAsync(Throwable cursorFailure) {
        ClientException exception = LockUtil.executeWithLock(this.lock, () -> this.state == State.TERMINATED ? new TransactionTerminatedException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription("Transaction can't be committed. It has been rolled back either because of an error or explicit termination"), "N/A", "Transaction can't be committed. It has been rolled back either because of an error or explicit termination", GqlStatusError.DIAGNOSTIC_RECORD, cursorFailure != this.causeOfTermination ? this.causeOfTermination : null) : null);
        if (exception != null) {
            return CompletableFuture.failedFuture(exception);
        }
        CompletableFuture commitSummary = new CompletableFuture();
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        this.connection.writeAndFlush((DriverResponseHandler)responseHandler, (Message)Messages.commit()).thenCompose(ignored -> responseHandler.summaries()).whenComplete((summaries, throwable) -> {
            if (throwable != null) {
                commitSummary.completeExceptionally((Throwable)throwable);
            } else {
                CommitSummary summary = summaries.commitSummary();
                if (summary != null) {
                    summary.bookmark().map(bookmark -> new DatabaseBookmark(null, Bookmark.from(bookmark))).ifPresent(this.bookmarkConsumer);
                    commitSummary.complete(summary);
                } else {
                    String message = summaries.ignored() > 0 ? "Commit exchange contains ignored messages" : "Unexpected state during commit";
                    throwable = new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null);
                    commitSummary.completeExceptionally((Throwable)throwable);
                }
            }
        });
        return commitSummary.thenApply(summary -> null);
    }

    private CompletionStage<Void> doRollbackAsync() {
        if (LockUtil.executeWithLock(this.lock, () -> this.state) == State.TERMINATED) {
            return Futures.completedWithNull();
        }
        CompletableFuture<Void> rollbackFuture = new CompletableFuture<Void>();
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        this.connection.writeAndFlush((DriverResponseHandler)responseHandler, (Message)Messages.rollback()).thenCompose(ignored -> responseHandler.summaries()).whenComplete((summaries, throwable) -> {
            if (throwable != null) {
                rollbackFuture.completeExceptionally((Throwable)throwable);
            } else {
                RollbackSummary summary = summaries.rollbackSummary();
                if (summary != null) {
                    rollbackFuture.complete(null);
                } else {
                    String message = summaries.ignored() > 0 ? "Rollback exchange contains ignored messages" : "Unexpected state during rollback";
                    throwable = new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null);
                    rollbackFuture.completeExceptionally((Throwable)throwable);
                }
            }
        });
        return rollbackFuture;
    }

    private static BiFunction<Void, Throwable, Void> handleCommitOrRollback(Throwable cursorFailure) {
        return (ignore, commitOrRollbackError) -> {
            CompletionException combinedError;
            if ((commitOrRollbackError = Futures.completionExceptionCause(commitOrRollbackError)) instanceof IllegalStateException) {
                commitOrRollbackError = ErrorUtil.newConnectionTerminatedError();
            }
            if ((combinedError = Futures.combineErrors(cursorFailure, commitOrRollbackError)) != null) {
                throw combinedError;
            }
            return null;
        };
    }

    private CompletionStage<Void> handleTransactionCompletion(boolean commitAttempt, Throwable throwable) {
        LockUtil.executeWithLock(this.lock, () -> {
            this.state = commitAttempt && throwable == null ? State.COMMITTED : State.ROLLED_BACK;
        });
        return this.connection.close().exceptionally(th -> null).thenCompose(ignored -> throwable != null ? CompletableFuture.failedStage(throwable) : CompletableFuture.completedStage(null));
    }

    private CompletionStage<Void> closeAsync(boolean commit, boolean completeWithNullIfNotOpen) {
        CompletableFuture<Void> stage = LockUtil.executeWithLock(this.lock, () -> {
            CompletableFuture<Object> resultStage = null;
            if (completeWithNullIfNotOpen && !this.isOpen()) {
                resultStage = Futures.completedWithNull();
            } else if (this.state == State.COMMITTED) {
                String message = commit ? CANT_COMMIT_COMMITTED_MSG : CANT_ROLLBACK_COMMITTED_MSG;
                resultStage = CompletableFuture.failedFuture(new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null));
            } else if (this.state == State.ROLLED_BACK) {
                String message = commit ? CANT_COMMIT_ROLLED_BACK_MSG : CANT_ROLLBACK_ROLLED_BACK_MSG;
                resultStage = CompletableFuture.failedFuture(new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null));
            } else if (commit) {
                if (this.rollbackFuture != null) {
                    resultStage = CompletableFuture.failedFuture(new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(CANT_COMMIT_ROLLING_BACK_MSG), "N/A", CANT_COMMIT_ROLLING_BACK_MSG, GqlStatusError.DIAGNOSTIC_RECORD, null));
                } else if (this.commitFuture != null) {
                    resultStage = this.commitFuture;
                } else {
                    this.commitFuture = new CompletableFuture();
                }
            } else if (this.commitFuture != null) {
                resultStage = CompletableFuture.failedFuture(new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(CANT_ROLLBACK_COMMITTING_MSG), "N/A", CANT_ROLLBACK_COMMITTING_MSG, GqlStatusError.DIAGNOSTIC_RECORD, null));
            } else if (this.rollbackFuture != null) {
                resultStage = this.rollbackFuture;
            } else {
                this.rollbackFuture = new CompletableFuture();
            }
            return resultStage;
        });
        if (stage == null) {
            Function<Throwable, CompletionStage> targetAction;
            CompletableFuture<Void> targetFuture;
            if (commit) {
                targetFuture = this.commitFuture;
                targetAction = throwable -> this.doCommitAsync((Throwable)throwable).handle(UnmanagedTransaction.handleCommitOrRollback(throwable));
            } else {
                targetFuture = this.rollbackFuture;
                targetAction = throwable -> this.doRollbackAsync().handle(UnmanagedTransaction.handleCommitOrRollback(throwable));
            }
            this.resultCursors.retrieveNotConsumedError().thenCompose(targetAction).handle((ignored, throwable) -> this.handleTransactionCompletion(commit, (Throwable)throwable)).thenCompose(Function.identity()).whenComplete(Futures.futureCompletingConsumer(targetFuture));
            stage = targetFuture;
        }
        return stage;
    }

    private static TransactionTerminatedException failedTxException(Throwable cause) {
        String message = "Cannot run more queries in this transaction, it has either experienced a fatal error or was explicitly terminated";
        return new TransactionTerminatedException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, cause);
    }

    private static TransactionType mapToTransactionType(String transactionType) {
        return "IMPLICIT".equals(transactionType) ? TransactionType.UNCONSTRAINED : TransactionType.DEFAULT;
    }

    private static enum State {
        ACTIVE,
        TERMINATED,
        COMMITTED,
        ROLLED_BACK;

    }

    private static class RunRxResponseHandler
    implements DriverResponseHandler {
        final CompletableFuture<RxResultCursor> cursorFuture = new CompletableFuture();
        private final Logging logging;
        private final ApiTelemetryWork apiTelemetryWork;
        private final CompletableFuture<UnmanagedTransaction> beginFuture;
        private final DriverBoltConnection connection;
        private final Query query;
        private Throwable error;
        private RunSummary runSummary;
        private int ignoredCount;

        private RunRxResponseHandler(Logging logging, ApiTelemetryWork apiTelemetryWork, CompletableFuture<UnmanagedTransaction> beginFuture, DriverBoltConnection connection, Query query) {
            this.logging = logging;
            this.apiTelemetryWork = apiTelemetryWork;
            this.beginFuture = beginFuture;
            this.connection = connection;
            this.query = query;
        }

        @Override
        public void onError(Throwable throwable) {
            throwable = Futures.completionExceptionCause(throwable);
            if (this.error == null) {
                this.error = throwable;
            } else if (this.error instanceof Neo4jException && !(throwable instanceof Neo4jException)) {
                this.error = throwable;
            }
        }

        @Override
        public void onTelemetrySummary(TelemetrySummary summary) {
            this.apiTelemetryWork.acknowledge();
        }

        @Override
        public void onRunSummary(RunSummary summary) {
            this.runSummary = summary;
        }

        @Override
        public void onIgnored() {
            ++this.ignoredCount;
        }

        @Override
        public void onComplete() {
            if (this.error != null) {
                if (!this.beginFuture.completeExceptionally(this.error)) {
                    this.cursorFuture.complete(new RxResultCursorImpl(this.connection, this.query, null, this.error, bookmark -> {}, false, this.logging));
                }
            } else if (this.runSummary != null) {
                this.cursorFuture.complete(new RxResultCursorImpl(this.connection, this.query, this.runSummary, null, bookmark -> {}, false, this.logging));
            } else {
                String message = this.ignoredCount > 0 ? "Run exchange contains ignored messages" : "Unexpected state during run";
                ClientException throwable = new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null);
                if (!this.beginFuture.completeExceptionally(throwable)) {
                    this.cursorFuture.completeExceptionally(throwable);
                }
            }
        }
    }

    private static class BeginResponseHandler
    implements DriverResponseHandler {
        final CompletableFuture<UnmanagedTransaction> summaryFuture = new CompletableFuture();
        private final ApiTelemetryWork apiTelemetryWork;
        private final Consumer<String> databaseNameConsumer;
        private Throwable error;
        private BeginSummary beginSummary;
        private int ignoredCount;

        private BeginResponseHandler(ApiTelemetryWork apiTelemetryWork, Consumer<String> databaseNameConsumer) {
            this.apiTelemetryWork = apiTelemetryWork;
            this.databaseNameConsumer = Objects.requireNonNull(databaseNameConsumer);
        }

        @Override
        public void onError(Throwable throwable) {
            throwable = Futures.completionExceptionCause(throwable);
            if (this.error == null) {
                this.error = throwable;
            } else if (this.error instanceof Neo4jException && !(throwable instanceof Neo4jException)) {
                this.error = throwable;
            }
        }

        @Override
        public void onBeginSummary(BeginSummary summary) {
            this.beginSummary = summary;
            summary.databaseName().ifPresent(this.databaseNameConsumer);
        }

        @Override
        public void onTelemetrySummary(TelemetrySummary summary) {
            this.apiTelemetryWork.acknowledge();
        }

        @Override
        public void onIgnored() {
            ++this.ignoredCount;
        }

        @Override
        public void onComplete() {
            if (this.error != null) {
                this.summaryFuture.completeExceptionally(this.error);
            } else if (this.beginSummary != null) {
                this.summaryFuture.complete(null);
            } else {
                String message = this.ignoredCount > 0 ? "Begin exchange contains ignored messages" : "Unexpected state during begin";
                ClientException throwable = new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null);
                this.summaryFuture.completeExceptionally(throwable);
            }
        }
    }
}

