/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.adaptedbolt;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.neo4j.bolt.connection.ResponseHandler;
import org.neo4j.bolt.connection.summary.BeginSummary;
import org.neo4j.bolt.connection.summary.CommitSummary;
import org.neo4j.bolt.connection.summary.DiscardSummary;
import org.neo4j.bolt.connection.summary.LogoffSummary;
import org.neo4j.bolt.connection.summary.LogonSummary;
import org.neo4j.bolt.connection.summary.ResetSummary;
import org.neo4j.bolt.connection.summary.RollbackSummary;
import org.neo4j.bolt.connection.summary.RouteSummary;
import org.neo4j.bolt.connection.summary.RunSummary;
import org.neo4j.bolt.connection.summary.TelemetrySummary;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.adaptedbolt.DriverResponseHandler;
import org.neo4j.driver.internal.adaptedbolt.ErrorMapper;
import org.neo4j.driver.internal.adaptedbolt.summary.PullSummary;
import org.neo4j.driver.internal.value.BoltValueFactory;

final class AdaptingDriverResponseHandler
implements ResponseHandler {
    private final DriverResponseHandler delegate;
    private final ErrorMapper errorMapper;
    private final BoltValueFactory boltValueFactory;

    AdaptingDriverResponseHandler(DriverResponseHandler delegate, ErrorMapper errorMapper, BoltValueFactory boltValueFactory) {
        this.delegate = Objects.requireNonNull(delegate);
        this.errorMapper = Objects.requireNonNull(errorMapper);
        this.boltValueFactory = Objects.requireNonNull(boltValueFactory);
    }

    public void onError(Throwable throwable) {
        this.delegate.onError(this.errorMapper.map(throwable));
    }

    public void onBeginSummary(BeginSummary summary) {
        this.delegate.onBeginSummary(summary);
    }

    public void onRunSummary(RunSummary summary) {
        this.delegate.onRunSummary(summary);
    }

    public void onRecord(List<org.neo4j.bolt.connection.values.Value> fields) {
        this.delegate.onRecord(this.boltValueFactory.toDriverList(fields));
    }

    public void onPullSummary(final org.neo4j.bolt.connection.summary.PullSummary summary) {
        this.delegate.onPullSummary(new PullSummary(){

            @Override
            public boolean hasMore() {
                return summary.hasMore();
            }

            @Override
            public Map<String, Value> metadata() {
                return AdaptingDriverResponseHandler.this.boltValueFactory.toDriverMap(summary.metadata());
            }
        });
    }

    public void onDiscardSummary(DiscardSummary summary) {
        this.delegate.onDiscardSummary(() -> this.boltValueFactory.toDriverMap(summary.metadata()));
    }

    public void onCommitSummary(CommitSummary summary) {
        this.delegate.onCommitSummary(summary);
    }

    public void onRollbackSummary(RollbackSummary summary) {
        this.delegate.onRollbackSummary(summary);
    }

    public void onResetSummary(ResetSummary summary) {
        this.delegate.onResetSummary(summary);
    }

    public void onRouteSummary(RouteSummary summary) {
        this.delegate.onRouteSummary(summary);
    }

    public void onLogoffSummary(LogoffSummary summary) {
        this.delegate.onLogoffSummary(summary);
    }

    public void onLogonSummary(LogonSummary summary) {
        this.delegate.onLogonSummary(summary);
    }

    public void onTelemetrySummary(TelemetrySummary summary) {
        this.delegate.onTelemetrySummary(summary);
    }

    public void onIgnored() {
        this.delegate.onIgnored();
    }

    public void onComplete() {
        this.delegate.onComplete();
    }
}

