/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.basicimpl.handlers;

import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.bolt.api.summary.RunSummary;
import org.neo4j.driver.internal.bolt.basicimpl.spi.ResponseHandler;
import org.neo4j.driver.internal.bolt.basicimpl.util.MetadataExtractor;

public class RunResponseHandler
implements ResponseHandler {
    private final CompletableFuture<RunSummary> runFuture;
    private final MetadataExtractor metadataExtractor;

    public RunResponseHandler(CompletableFuture<RunSummary> runFuture, MetadataExtractor metadataExtractor) {
        this.runFuture = runFuture;
        this.metadataExtractor = metadataExtractor;
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        List<String> queryKeys = this.metadataExtractor.extractQueryKeys(metadata);
        long resultAvailableAfter = this.metadataExtractor.extractResultAvailableAfter(metadata);
        long queryId = this.metadataExtractor.extractQueryId(metadata);
        this.runFuture.complete(new RunResponseImpl(queryId, queryKeys, resultAvailableAfter));
    }

    @Override
    public void onFailure(Throwable error) {
        this.runFuture.completeExceptionally(error);
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new UnsupportedOperationException();
    }

    private record RunResponseImpl(long queryId, List<String> keys, long resultAvailableAfter) implements RunSummary
    {
    }
}

