/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.URI;
import java.time.Clock;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.ClientCertificateManager;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.MetricsAdapter;
import org.neo4j.driver.internal.BoltLoggingProvider;
import org.neo4j.driver.internal.IdentityResolver;
import org.neo4j.driver.internal.InternalDriver;
import org.neo4j.driver.internal.InternalServerAddress;
import org.neo4j.driver.internal.RoutingSettings;
import org.neo4j.driver.internal.SecuritySettings;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.SessionFactoryImpl;
import org.neo4j.driver.internal.bolt.api.BoltConnectionProvider;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.api.DefaultDomainNameResolver;
import org.neo4j.driver.internal.bolt.api.DomainNameResolver;
import org.neo4j.driver.internal.bolt.api.LoggingProvider;
import org.neo4j.driver.internal.bolt.api.RoutingContext;
import org.neo4j.driver.internal.bolt.basicimpl.NettyBoltConnectionProvider;
import org.neo4j.driver.internal.bolt.basicimpl.async.connection.BootstrapFactory;
import org.neo4j.driver.internal.bolt.pooledimpl.PooledBoltConnectionProvider;
import org.neo4j.driver.internal.bolt.routedimpl.RoutedBoltConnectionProvider;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.Rediscovery;
import org.neo4j.driver.internal.metrics.DevNullMetricsProvider;
import org.neo4j.driver.internal.metrics.InternalMetricsProvider;
import org.neo4j.driver.internal.metrics.MetricsProvider;
import org.neo4j.driver.internal.metrics.MicrometerMetricsProvider;
import org.neo4j.driver.internal.retry.ExponentialBackoffRetryLogic;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.security.BoltSecurityPlanManager;
import org.neo4j.driver.internal.security.SecurityPlan;
import org.neo4j.driver.internal.security.SecurityPlans;
import org.neo4j.driver.internal.util.DriverInfoUtil;
import org.neo4j.driver.net.ServerAddress;
import org.neo4j.driver.net.ServerAddressResolver;

public class DriverFactory {
    public static final String NO_ROUTING_CONTEXT_ERROR_MESSAGE = "Routing parameters are not supported with scheme 'bolt'. Given URI: ";

    public final Driver newInstance(URI uri, AuthTokenManager authTokenManager, ClientCertificateManager clientCertificateManager, Config config) {
        return this.newInstance(uri, authTokenManager, clientCertificateManager, config, null, null, null);
    }

    public final Driver newInstance(URI uri, AuthTokenManager authTokenManager, ClientCertificateManager clientCertificateManager, Config config, SecurityPlan securityPlan, EventLoopGroup eventLoopGroup, Supplier<Rediscovery> rediscoverySupplier) {
        if (securityPlan == null) {
            SecuritySettings settings = new SecuritySettings(config.encrypted(), config.trustStrategy());
            securityPlan = SecurityPlans.createSecurityPlan(settings, uri.getScheme(), clientCertificateManager, config.logging());
        }
        BoltSecurityPlanManager securityPlanManager = BoltSecurityPlanManager.from(securityPlan);
        return this.newInstance(uri, authTokenManager, config, securityPlanManager, eventLoopGroup, rediscoverySupplier);
    }

    public final Driver newInstance(URI uri, AuthTokenManager authTokenManager, Config config, BoltSecurityPlanManager securityPlanManager, EventLoopGroup eventLoopGroup, Supplier<Rediscovery> rediscoverySupplier) {
        boolean ownsEventLoopGroup;
        Bootstrap bootstrap;
        Objects.requireNonNull(authTokenManager, "authTokenProvider must not be null");
        if (eventLoopGroup == null) {
            bootstrap = this.createBootstrap(config.eventLoopThreads());
            ownsEventLoopGroup = true;
        } else {
            bootstrap = this.createBootstrap(eventLoopGroup);
            ownsEventLoopGroup = false;
        }
        InternalServerAddress address = new InternalServerAddress(uri);
        RoutingSettings routingSettings = new RoutingSettings(config.routingTablePurgeDelayMillis(), new RoutingContext(uri));
        EventLoopGroup eventExecutorGroup = bootstrap.config().group();
        RetryLogic retryLogic = this.createRetryLogic(config.maxTransactionRetryTimeMillis(), (EventExecutorGroup)eventExecutorGroup, config.logging());
        MetricsProvider metricsProvider = DriverFactory.getOrCreateMetricsProvider(config, this.createClock());
        return this.createDriver(uri, securityPlanManager, address, bootstrap.group(), routingSettings, retryLogic, metricsProvider, config, authTokenManager, ownsEventLoopGroup, rediscoverySupplier);
    }

    protected static MetricsProvider getOrCreateMetricsProvider(Config config, Clock clock) {
        MetricsAdapter metricsAdapter = config.metricsAdapter();
        if (metricsAdapter == null) {
            metricsAdapter = config.isMetricsEnabled() ? MetricsAdapter.DEFAULT : MetricsAdapter.DEV_NULL;
        }
        return switch (metricsAdapter) {
            default -> throw new IncompatibleClassChangeError();
            case MetricsAdapter.DEV_NULL -> DevNullMetricsProvider.INSTANCE;
            case MetricsAdapter.DEFAULT -> new InternalMetricsProvider(clock, config.logging());
            case MetricsAdapter.MICROMETER -> MicrometerMetricsProvider.forGlobalRegistry();
        };
    }

    private InternalDriver createDriver(URI uri, BoltSecurityPlanManager securityPlanManager, ServerAddress address, EventLoopGroup eventLoopGroup, RoutingSettings routingSettings, RetryLogic retryLogic, MetricsProvider metricsProvider, Config config, AuthTokenManager authTokenManager, boolean ownsEventLoopGroup, Supplier<Rediscovery> rediscoverySupplier) {
        BoltConnectionProvider boltConnectionProvider = null;
        try {
            boltConnectionProvider = this.createBoltConnectionProvider(uri, config, eventLoopGroup, routingSettings, rediscoverySupplier);
            boltConnectionProvider.init(new BoltServerAddress(address.host(), address.port()), new RoutingContext(uri), DriverInfoUtil.boltAgent(), config.userAgent(), config.connectionTimeoutMillis(), metricsProvider.metricsListener());
            SessionFactory sessionFactory = this.createSessionFactory(securityPlanManager, boltConnectionProvider, retryLogic, config, authTokenManager);
            Supplier<CompletionStage<Void>> shutdownSupplier = ownsEventLoopGroup ? () -> {
                CompletableFuture closeFuture = new CompletableFuture();
                eventLoopGroup.shutdownGracefully(200L, 15000L, TimeUnit.MILLISECONDS).addListener(future -> closeFuture.complete(null));
                return closeFuture;
            } : () -> CompletableFuture.completedStage(null);
            InternalDriver driver = this.createDriver(securityPlanManager, sessionFactory, metricsProvider, shutdownSupplier, config);
            Logger log = config.logging().getLog(this.getClass());
            if (uri.getScheme().startsWith("bolt")) {
                log.info("Direct driver instance %s created for server address %s", driver.hashCode(), address);
            } else {
                log.info("Routing driver instance %s created for server address %s", driver.hashCode(), address);
            }
            return driver;
        }
        catch (Throwable driverError) {
            if (boltConnectionProvider != null) {
                boltConnectionProvider.close().toCompletableFuture().join();
            }
            throw driverError;
        }
    }

    private Function<BoltServerAddress, Set<BoltServerAddress>> createBoltServerAddressResolver(Config config) {
        ServerAddressResolver serverAddressResolver = config.resolver() != null ? config.resolver() : IdentityResolver.IDENTITY_RESOLVER;
        return boltAddress -> serverAddressResolver.resolve(ServerAddress.of(boltAddress.host(), boltAddress.port())).stream().map(serverAddress -> new BoltServerAddress(serverAddress.host(), serverAddress.port())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private BoltConnectionProvider createBoltConnectionProvider(URI uri, Config config, EventLoopGroup eventLoopGroup, RoutingSettings routingSettings, Supplier<Rediscovery> rediscoverySupplier) {
        BoltConnectionProvider boltConnectionProvider;
        Clock clock = this.createClock();
        BoltLoggingProvider loggingProvider = new BoltLoggingProvider(config.logging());
        Supplier<BoltConnectionProvider> pooledBoltConnectionProviderSupplier = () -> this.createPooledBoltConnectionProvider(config, eventLoopGroup, clock, loggingProvider);
        if (uri.getScheme().startsWith("bolt")) {
            DriverFactory.assertNoRoutingContext(uri, routingSettings);
            boltConnectionProvider = pooledBoltConnectionProviderSupplier.get();
        } else {
            boltConnectionProvider = this.createRoutedBoltConnectionProvider(config, pooledBoltConnectionProviderSupplier, routingSettings, rediscoverySupplier, clock, loggingProvider);
        }
        return boltConnectionProvider;
    }

    private BoltConnectionProvider createRoutedBoltConnectionProvider(Config config, Supplier<BoltConnectionProvider> pooledBoltConnectionProviderSupplier, RoutingSettings routingSettings, Supplier<Rediscovery> rediscoverySupplier, Clock clock, LoggingProvider loggingProvider) {
        Function<BoltServerAddress, Set<BoltServerAddress>> boltServerAddressResolver = this.createBoltServerAddressResolver(config);
        Rediscovery rediscovery = rediscoverySupplier != null ? rediscoverySupplier.get() : null;
        return new RoutedBoltConnectionProvider(pooledBoltConnectionProviderSupplier, boltServerAddressResolver, this.getDomainNameResolver(), routingSettings.routingTablePurgeDelayMs(), rediscovery, clock, loggingProvider);
    }

    private BoltConnectionProvider createPooledBoltConnectionProvider(Config config, EventLoopGroup eventLoopGroup, Clock clock, LoggingProvider loggingProvider) {
        BoltConnectionProvider nettyBoltConnectionProvider = this.createNettyBoltConnectionProvider(eventLoopGroup, clock, loggingProvider);
        return new PooledBoltConnectionProvider(nettyBoltConnectionProvider, config.maxConnectionPoolSize(), config.connectionAcquisitionTimeoutMillis(), config.maxConnectionLifetimeMillis(), config.idleTimeBeforeConnectionTest(), clock, loggingProvider);
    }

    private BoltConnectionProvider createNettyBoltConnectionProvider(EventLoopGroup eventLoopGroup, Clock clock, LoggingProvider loggingProvider) {
        return new NettyBoltConnectionProvider(eventLoopGroup, clock, this.getDomainNameResolver(), this.localAddress(), loggingProvider);
    }

    protected LocalAddress localAddress() {
        return null;
    }

    protected InternalDriver createDriver(BoltSecurityPlanManager securityPlanManager, SessionFactory sessionFactory, MetricsProvider metricsProvider, Supplier<CompletionStage<Void>> shutdownSupplier, Config config) {
        return new InternalDriver(securityPlanManager, sessionFactory, metricsProvider, config.isTelemetryDisabled(), config.notificationConfig(), shutdownSupplier, config.logging());
    }

    protected Clock createClock() {
        return Clock.systemUTC();
    }

    protected SessionFactory createSessionFactory(BoltSecurityPlanManager securityPlanManager, BoltConnectionProvider connectionProvider, RetryLogic retryLogic, Config config, AuthTokenManager authTokenManager) {
        return new SessionFactoryImpl(securityPlanManager, connectionProvider, retryLogic, config, authTokenManager);
    }

    protected RetryLogic createRetryLogic(long maxTransactionRetryTime, EventExecutorGroup eventExecutorGroup, Logging logging) {
        return new ExponentialBackoffRetryLogic(maxTransactionRetryTime, eventExecutorGroup, this.createClock(), logging);
    }

    protected Bootstrap createBootstrap(int size) {
        return BootstrapFactory.newBootstrap(size);
    }

    protected Bootstrap createBootstrap(EventLoopGroup eventLoopGroup) {
        return BootstrapFactory.newBootstrap(eventLoopGroup);
    }

    protected DomainNameResolver getDomainNameResolver() {
        return DefaultDomainNameResolver.getInstance();
    }

    private static void assertNoRoutingContext(URI uri, RoutingSettings routingSettings) {
        RoutingContext routingContext = routingSettings.routingContext();
        if (routingContext.isDefined()) {
            throw new IllegalArgumentException("Routing parameters are not supported with scheme 'bolt'. Given URI: '" + uri + "'");
        }
    }
}

