/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.routedimpl.cluster;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.bolt.api.AccessMode;
import org.neo4j.driver.internal.bolt.api.BoltConnectionProvider;
import org.neo4j.driver.internal.bolt.api.BoltProtocolVersion;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.api.DatabaseName;
import org.neo4j.driver.internal.bolt.api.LoggingProvider;
import org.neo4j.driver.internal.bolt.api.SecurityPlan;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.ClusterCompositionLookupResult;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.Rediscovery;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.RoutingTable;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.RoutingTableHandler;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.RoutingTableRegistry;
import org.neo4j.driver.internal.bolt.routedimpl.util.FutureUtil;

public class RoutingTableHandlerImpl
implements RoutingTableHandler {
    private final RoutingTable routingTable;
    private final DatabaseName databaseName;
    private final RoutingTableRegistry routingTableRegistry;
    private volatile CompletableFuture<RoutingTable> refreshRoutingTableFuture;
    private final Function<BoltServerAddress, BoltConnectionProvider> connectionProviderGetter;
    private final Rediscovery rediscovery;
    private final System.Logger log;
    private final long routingTablePurgeDelayMs;
    private final Set<BoltServerAddress> resolvedInitialRouters = new HashSet<BoltServerAddress>();
    private final Consumer<Set<BoltServerAddress>> addressesToRetainConsumer;

    public RoutingTableHandlerImpl(RoutingTable routingTable, Rediscovery rediscovery, Function<BoltServerAddress, BoltConnectionProvider> connectionProviderGetter, RoutingTableRegistry routingTableRegistry, LoggingProvider logging, long routingTablePurgeDelayMs, Consumer<Set<BoltServerAddress>> addressesToRetainConsumer) {
        this.routingTable = routingTable;
        this.databaseName = routingTable.database();
        this.rediscovery = rediscovery;
        this.connectionProviderGetter = connectionProviderGetter;
        this.routingTableRegistry = routingTableRegistry;
        this.log = logging.getLog(this.getClass());
        this.routingTablePurgeDelayMs = routingTablePurgeDelayMs;
        this.addressesToRetainConsumer = addressesToRetainConsumer;
    }

    @Override
    public void onConnectionFailure(BoltServerAddress address) {
        this.routingTable.forget(address);
    }

    @Override
    public void onWriteFailure(BoltServerAddress address) {
        this.routingTable.forgetWriter(address);
    }

    @Override
    public synchronized CompletionStage<RoutingTable> ensureRoutingTable(SecurityPlan securityPlan, AccessMode mode, Set<String> rediscoveryBookmarks, Supplier<CompletionStage<Map<String, Value>>> authMapStageSupplier, BoltProtocolVersion minVersion) {
        if (this.refreshRoutingTableFuture != null) {
            return this.refreshRoutingTableFuture;
        }
        if (this.routingTable.isStaleFor(mode)) {
            this.log.log(System.Logger.Level.DEBUG, "Routing table for database '%s' is stale. %s", this.databaseName.description(), this.routingTable);
            CompletableFuture<RoutingTable> resultFuture = new CompletableFuture<RoutingTable>();
            this.refreshRoutingTableFuture = resultFuture;
            this.rediscovery.lookupClusterComposition(securityPlan, this.routingTable, this.connectionProviderGetter, rediscoveryBookmarks, null, authMapStageSupplier, minVersion).whenComplete((composition, completionError) -> {
                Throwable error = FutureUtil.completionExceptionCause(completionError);
                if (error != null) {
                    this.clusterCompositionLookupFailed(error);
                } else {
                    this.freshClusterCompositionFetched((ClusterCompositionLookupResult)composition);
                }
            });
            return resultFuture;
        }
        return CompletableFuture.completedFuture(this.routingTable);
    }

    @Override
    public synchronized CompletionStage<RoutingTable> updateRoutingTable(ClusterCompositionLookupResult compositionLookupResult) {
        if (this.refreshRoutingTableFuture != null) {
            return this.refreshRoutingTableFuture;
        }
        if (compositionLookupResult.getClusterComposition().expirationTimestamp() < this.routingTable.expirationTimestamp()) {
            return CompletableFuture.completedFuture(this.routingTable);
        }
        CompletableFuture<RoutingTable> resultFuture = new CompletableFuture<RoutingTable>();
        this.refreshRoutingTableFuture = resultFuture;
        this.freshClusterCompositionFetched(compositionLookupResult);
        return resultFuture;
    }

    private synchronized void freshClusterCompositionFetched(ClusterCompositionLookupResult compositionLookupResult) {
        try {
            this.log.log(System.Logger.Level.DEBUG, "Fetched cluster composition for database '%s'. %s", this.databaseName.description(), compositionLookupResult.getClusterComposition());
            this.routingTable.update(compositionLookupResult.getClusterComposition());
            this.routingTableRegistry.removeAged();
            LinkedHashSet<BoltServerAddress> addressesToRetain = new LinkedHashSet<BoltServerAddress>();
            this.routingTableRegistry.allServers().stream().flatMap(BoltServerAddress::unicastStream).forEach(addressesToRetain::add);
            compositionLookupResult.getResolvedInitialRouters().ifPresent(addresses -> {
                this.resolvedInitialRouters.clear();
                this.resolvedInitialRouters.addAll((Collection<BoltServerAddress>)addresses);
            });
            addressesToRetain.addAll(this.resolvedInitialRouters);
            this.addressesToRetainConsumer.accept(addressesToRetain);
            this.log.log(System.Logger.Level.DEBUG, "Updated routing table for database '%s'. %s", this.databaseName.description(), this.routingTable);
            CompletableFuture<RoutingTable> routingTableFuture = this.refreshRoutingTableFuture;
            this.refreshRoutingTableFuture = null;
            routingTableFuture.complete(this.routingTable);
        }
        catch (Throwable error) {
            this.clusterCompositionLookupFailed(error);
        }
    }

    private synchronized void clusterCompositionLookupFailed(Throwable error) {
        this.log.log(System.Logger.Level.ERROR, String.format("Failed to update routing table for database '%s'. Current routing table: %s.", this.databaseName.description(), this.routingTable), error);
        this.routingTableRegistry.remove(this.databaseName);
        CompletableFuture<RoutingTable> routingTableFuture = this.refreshRoutingTableFuture;
        this.refreshRoutingTableFuture = null;
        routingTableFuture.completeExceptionally(error);
    }

    @Override
    public Set<BoltServerAddress> servers() {
        return this.routingTable.servers();
    }

    @Override
    public boolean isRoutingTableAged() {
        return this.refreshRoutingTableFuture == null && this.routingTable.hasBeenStaleFor(this.routingTablePurgeDelayMs);
    }

    @Override
    public RoutingTable routingTable() {
        return this.routingTable;
    }
}

