/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokenManager;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.BookmarkManager;
import org.neo4j.driver.Config;
import org.neo4j.driver.Logging;
import org.neo4j.driver.NotificationConfig;
import org.neo4j.driver.SessionConfig;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.NoOpBookmarkManager;
import org.neo4j.driver.internal.SessionFactory;
import org.neo4j.driver.internal.async.LeakLoggingNetworkSession;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.bolt.api.BoltConnectionProvider;
import org.neo4j.driver.internal.bolt.api.DatabaseName;
import org.neo4j.driver.internal.bolt.api.DatabaseNameUtil;
import org.neo4j.driver.internal.bolt.api.SecurityPlan;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.security.BoltSecurityPlanManager;
import org.neo4j.driver.internal.security.InternalAuthToken;

public class SessionFactoryImpl
implements SessionFactory {
    private final BoltSecurityPlanManager securityPlanManager;
    private final BoltConnectionProvider connectionProvider;
    private final RetryLogic retryLogic;
    private final Logging logging;
    private final boolean leakedSessionsLoggingEnabled;
    private final long defaultFetchSize;
    private final AuthTokenManager authTokenManager;

    SessionFactoryImpl(BoltSecurityPlanManager securityPlanManager, BoltConnectionProvider connectionProvider, RetryLogic retryLogic, Config config, AuthTokenManager authTokenManager) {
        this.securityPlanManager = Objects.requireNonNull(securityPlanManager);
        this.connectionProvider = connectionProvider;
        this.leakedSessionsLoggingEnabled = config.logLeakedSessions();
        this.retryLogic = retryLogic;
        this.logging = config.logging();
        this.defaultFetchSize = config.fetchSize();
        this.authTokenManager = authTokenManager;
    }

    @Override
    public NetworkSession newInstance(SessionConfig sessionConfig, NotificationConfig notificationConfig, AuthToken overrideAuthToken, boolean telemetryDisabled) {
        return this.createSession(this.securityPlanManager, this.connectionProvider, this.retryLogic, this.parseDatabaseName(sessionConfig), sessionConfig.defaultAccessMode(), this.toDistinctSet(sessionConfig.bookmarks()), this.parseFetchSize(sessionConfig), sessionConfig.impersonatedUser().orElse(null), this.logging, sessionConfig.bookmarkManager().orElse(NoOpBookmarkManager.INSTANCE), notificationConfig, sessionConfig.notificationConfig(), overrideAuthToken, telemetryDisabled, this.authTokenManager);
    }

    private Set<Bookmark> toDistinctSet(Iterable<Bookmark> bookmarks) {
        HashSet<Bookmark> set = new HashSet<Bookmark>();
        if (bookmarks != null) {
            for (Bookmark bookmark : bookmarks) {
                if (bookmark == null) continue;
                Set<String> values = bookmark.values();
                int size = values.size();
                if (size == 1) {
                    set.add(bookmark);
                    continue;
                }
                if (size <= 1) continue;
                for (String value : values) {
                    set.add(Bookmark.from(value));
                }
            }
        }
        return Collections.unmodifiableSet(set);
    }

    private long parseFetchSize(SessionConfig sessionConfig) {
        return sessionConfig.fetchSize().orElse(this.defaultFetchSize);
    }

    private DatabaseName parseDatabaseName(SessionConfig sessionConfig) {
        return sessionConfig.database().flatMap(name -> Optional.of(DatabaseNameUtil.database(name))).orElse(DatabaseNameUtil.defaultDatabase());
    }

    @Override
    public CompletionStage<Void> verifyConnectivity() {
        return this.securityPlanManager.plan().thenCompose(securityPlan -> this.authTokenManager.getToken().thenApply(authToken -> new SecurityPlanAndAuthToken((SecurityPlan)securityPlan, ((InternalAuthToken)authToken).toMap()))).thenCompose(tuple -> this.connectionProvider.verifyConnectivity(tuple.securityPlan(), tuple.authToken()));
    }

    @Override
    public CompletionStage<Void> close() {
        return this.connectionProvider.close();
    }

    @Override
    public CompletionStage<Boolean> supportsMultiDb() {
        return this.securityPlanManager.plan().thenCompose(securityPlan -> this.authTokenManager.getToken().thenApply(authToken -> new SecurityPlanAndAuthToken((SecurityPlan)securityPlan, ((InternalAuthToken)authToken).toMap()))).thenCompose(tuple -> this.connectionProvider.supportsMultiDb(tuple.securityPlan(), tuple.authToken()));
    }

    @Override
    public CompletionStage<Boolean> supportsSessionAuth() {
        return this.securityPlanManager.plan().thenCompose(securityPlan -> this.authTokenManager.getToken().thenApply(authToken -> new SecurityPlanAndAuthToken((SecurityPlan)securityPlan, ((InternalAuthToken)authToken).toMap()))).thenCompose(tuple -> this.connectionProvider.supportsSessionAuth(tuple.securityPlan(), tuple.authToken()));
    }

    private NetworkSession createSession(BoltSecurityPlanManager securityPlanManager, BoltConnectionProvider connectionProvider, RetryLogic retryLogic, DatabaseName databaseName, AccessMode mode, Set<Bookmark> bookmarks, long fetchSize, String impersonatedUser, Logging logging, BookmarkManager bookmarkManager, NotificationConfig driverNotificationConfig, NotificationConfig notificationConfig, AuthToken authToken, boolean telemetryDisabled, AuthTokenManager authTokenManager) {
        Objects.requireNonNull(bookmarks, "bookmarks may not be null");
        Objects.requireNonNull(bookmarkManager, "bookmarkManager may not be null");
        return this.leakedSessionsLoggingEnabled ? new LeakLoggingNetworkSession(securityPlanManager, connectionProvider, retryLogic, databaseName, mode, bookmarks, impersonatedUser, fetchSize, logging, bookmarkManager, driverNotificationConfig, notificationConfig, authToken, telemetryDisabled, authTokenManager) : new NetworkSession(securityPlanManager, connectionProvider, retryLogic, databaseName, mode, bookmarks, impersonatedUser, fetchSize, logging, bookmarkManager, driverNotificationConfig, notificationConfig, authToken, telemetryDisabled, authTokenManager);
    }

    public BoltConnectionProvider getConnectionProvider() {
        return this.connectionProvider;
    }

    private record SecurityPlanAndAuthToken(SecurityPlan securityPlan, Map<String, Value> authToken) {
    }
}

