/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.basicimpl.handlers;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.bolt.api.summary.DiscardSummary;
import org.neo4j.driver.internal.bolt.basicimpl.spi.ResponseHandler;
import org.neo4j.driver.internal.value.BooleanValue;

public class DiscardResponseHandler
implements ResponseHandler {
    private final CompletableFuture<DiscardSummary> future;

    public DiscardResponseHandler(CompletableFuture<DiscardSummary> future) {
        this.future = Objects.requireNonNull(future, "future must not be null");
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        boolean hasMore = metadata.getOrDefault("has_more", BooleanValue.FALSE).asBoolean();
        this.future.complete(new DiscardSummaryImpl(metadata));
    }

    @Override
    public void onFailure(Throwable error) {
        this.future.completeExceptionally(error);
    }

    @Override
    public void onRecord(Value[] fields) {
    }

    private record DiscardSummaryImpl(Map<String, Value> metadata) implements DiscardSummary
    {
    }
}

