/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.basicimpl.async;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.api.LoggingProvider;
import org.neo4j.driver.internal.bolt.basicimpl.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.bolt.basicimpl.async.inbound.ConnectionReadTimeoutHandler;
import org.neo4j.driver.internal.bolt.basicimpl.async.inbound.InboundMessageDispatcher;
import org.neo4j.driver.internal.bolt.basicimpl.handlers.NoOpResponseHandler;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.BoltProtocol;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.Message;
import org.neo4j.driver.internal.bolt.basicimpl.messaging.request.GoodbyeMessage;
import org.neo4j.driver.internal.bolt.basicimpl.spi.Connection;
import org.neo4j.driver.internal.bolt.basicimpl.spi.ResponseHandler;
import org.neo4j.driver.internal.bolt.basicimpl.util.LockUtil;

public class NetworkConnection
implements Connection {
    private final System.Logger log;
    private final Lock lock;
    private final Channel channel;
    private final InboundMessageDispatcher messageDispatcher;
    private final String serverAgent;
    private final BoltServerAddress serverAddress;
    private final boolean telemetryEnabled;
    private final BoltProtocol protocol;
    private final Long connectionReadTimeout;
    private ChannelHandler connectionReadTimeoutHandler;

    public NetworkConnection(Channel channel, LoggingProvider logging) {
        this.log = logging.getLog(this.getClass());
        this.lock = new ReentrantLock();
        this.channel = channel;
        this.messageDispatcher = ChannelAttributes.messageDispatcher(channel);
        this.serverAgent = ChannelAttributes.serverAgent(channel);
        this.serverAddress = ChannelAttributes.serverAddress(channel);
        this.telemetryEnabled = ChannelAttributes.telemetryEnabled(channel);
        this.protocol = BoltProtocol.forChannel(channel);
        this.connectionReadTimeout = ChannelAttributes.connectionReadTimeout(channel).orElse(null);
    }

    @Override
    public boolean isOpen() {
        return LockUtil.executeWithLock(this.lock, () -> ((Channel)this.channel).isOpen());
    }

    @Override
    public void enableAutoRead() {
        if (this.isOpen()) {
            this.setAutoRead(true);
        }
    }

    @Override
    public void disableAutoRead() {
        if (this.isOpen()) {
            this.setAutoRead(false);
        }
    }

    @Override
    public CompletionStage<Void> write(Message message, ResponseHandler handler) {
        return this.writeMessageInEventLoop(message, handler);
    }

    @Override
    public CompletionStage<Void> flush() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.channel.eventLoop().execute(() -> {
            this.channel.flush();
            future.complete(null);
        });
        return future;
    }

    @Override
    public boolean isTelemetryEnabled() {
        return this.telemetryEnabled;
    }

    @Override
    public String serverAgent() {
        return this.serverAgent;
    }

    @Override
    public BoltServerAddress serverAddress() {
        return this.serverAddress;
    }

    @Override
    public BoltProtocol protocol() {
        return this.protocol;
    }

    @Override
    public CompletionStage<Void> forceClose(String reason) {
        CompletableFuture<Void> fut = new CompletableFuture<Void>();
        this.eventLoop().execute(() -> {
            ChannelAttributes.setTerminationReason(this.channel, reason);
            this.channel.close().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    fut.complete(null);
                } else {
                    Throwable cause = future.cause();
                    if (cause == null) {
                        cause = new IllegalStateException("Unexpected state");
                    }
                    fut.completeExceptionally(cause);
                }
            }));
        });
        return fut;
    }

    @Override
    public CompletionStage<Void> close() {
        CompletableFuture<Void> closeFuture = new CompletableFuture<Void>();
        this.writeMessageInEventLoop(GoodbyeMessage.GOODBYE, new NoOpResponseHandler()).thenCompose(ignored -> this.flush()).whenComplete((ignored, throwable) -> {
            if (throwable == null) {
                this.channel.close().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                    if (future.isSuccess()) {
                        closeFuture.complete(null);
                    } else {
                        closeFuture.completeExceptionally(future.cause());
                    }
                }));
            } else {
                closeFuture.completeExceptionally((Throwable)throwable);
            }
        });
        return closeFuture;
    }

    @Override
    public EventLoop eventLoop() {
        return this.channel.eventLoop();
    }

    private CompletionStage<Void> writeMessageInEventLoop(Message message, ResponseHandler handler) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        Runnable runnable = () -> {
            if (this.messageDispatcher.fatalErrorOccurred() && GoodbyeMessage.GOODBYE.equals(message)) {
                future.complete(null);
                handler.onSuccess(Collections.emptyMap());
                this.channel.close();
                return;
            }
            this.messageDispatcher.enqueue(handler);
            this.channel.write((Object)message).addListener(writeFuture -> {
                if (writeFuture.isSuccess()) {
                    this.registerConnectionReadTimeout(this.channel);
                } else {
                    future.completeExceptionally(writeFuture.cause());
                }
            });
            future.complete(null);
        };
        if (this.channel.eventLoop().inEventLoop()) {
            runnable.run();
        } else {
            this.channel.eventLoop().execute(runnable);
        }
        return future;
    }

    private void setAutoRead(boolean value) {
        this.channel.config().setAutoRead(value);
    }

    private void registerConnectionReadTimeout(Channel channel) {
        if (!channel.eventLoop().inEventLoop()) {
            throw new IllegalStateException("This method may only be called in the EventLoop");
        }
        if (this.connectionReadTimeout != null && this.connectionReadTimeoutHandler == null) {
            this.connectionReadTimeoutHandler = new ConnectionReadTimeoutHandler(this.connectionReadTimeout, TimeUnit.SECONDS);
            channel.pipeline().addFirst(new ChannelHandler[]{this.connectionReadTimeoutHandler});
            this.log.log(System.Logger.Level.DEBUG, "Added ConnectionReadTimeoutHandler");
            this.messageDispatcher.setBeforeLastHandlerHook(() -> {
                channel.pipeline().remove(this.connectionReadTimeoutHandler);
                this.connectionReadTimeoutHandler = null;
                this.messageDispatcher.setBeforeLastHandlerHook(null);
                this.log.log(System.Logger.Level.DEBUG, "Removed ConnectionReadTimeoutHandler");
            });
        }
    }
}

