/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.routedimpl.cluster.loadbalancing;

import java.util.List;
import java.util.function.Function;
import org.neo4j.driver.internal.bolt.api.BoltServerAddress;
import org.neo4j.driver.internal.bolt.api.LoggingProvider;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.loadbalancing.LoadBalancingStrategy;
import org.neo4j.driver.internal.bolt.routedimpl.cluster.loadbalancing.RoundRobinArrayIndex;

public class LeastConnectedLoadBalancingStrategy
implements LoadBalancingStrategy {
    private final RoundRobinArrayIndex readersIndex = new RoundRobinArrayIndex();
    private final RoundRobinArrayIndex writersIndex = new RoundRobinArrayIndex();
    private final Function<BoltServerAddress, Integer> inUseFunction;
    private final System.Logger log;

    public LeastConnectedLoadBalancingStrategy(Function<BoltServerAddress, Integer> inUseFunction, LoggingProvider logging) {
        this.inUseFunction = inUseFunction;
        this.log = logging.getLog(this.getClass());
    }

    @Override
    public BoltServerAddress selectReader(List<BoltServerAddress> knownReaders) {
        return this.select(knownReaders, this.readersIndex, "reader");
    }

    @Override
    public BoltServerAddress selectWriter(List<BoltServerAddress> knownWriters) {
        return this.select(knownWriters, this.writersIndex, "writer");
    }

    private BoltServerAddress select(List<BoltServerAddress> addresses, RoundRobinArrayIndex addressesIndex, String addressType) {
        int startIndex;
        int size = addresses.size();
        if (size == 0) {
            this.log.log(System.Logger.Level.TRACE, "Unable to select %s, no known addresses given", addressType);
            return null;
        }
        int index = startIndex = addressesIndex.next(size);
        BoltServerAddress leastConnectedAddress = null;
        int leastActiveConnections = Integer.MAX_VALUE;
        do {
            BoltServerAddress address;
            Integer activeConnections;
            if ((activeConnections = this.inUseFunction.apply(address = addresses.get(index))) < leastActiveConnections) {
                leastConnectedAddress = address;
                leastActiveConnections = activeConnections;
            }
            if (index == size - 1) {
                index = 0;
                continue;
            }
            ++index;
        } while (index != startIndex);
        this.log.log(System.Logger.Level.TRACE, "Selected %s with address: '%s' and active connections: %s", addressType, leastConnectedAddress, leastActiveConnections);
        return leastConnectedAddress;
    }
}

