/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.bolt.basicimpl.handlers;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.bolt.basicimpl.spi.ResponseHandler;

public class RouteMessageResponseHandler
implements ResponseHandler {
    private final CompletableFuture<Map<String, Value>> completableFuture;

    public RouteMessageResponseHandler(CompletableFuture<Map<String, Value>> completableFuture) {
        this.completableFuture = Objects.requireNonNull(completableFuture);
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        try {
            this.completableFuture.complete(metadata.get("rt").asMap(Values::value));
        }
        catch (Exception ex) {
            this.completableFuture.completeExceptionally(ex);
        }
    }

    @Override
    public void onFailure(Throwable error) {
        this.completableFuture.completeExceptionally(error);
    }

    @Override
    public void onRecord(Value[] fields) {
        this.completableFuture.completeExceptionally(new UnsupportedOperationException("Route is not expected to receive records: " + Arrays.toString(fields)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteMessageResponseHandler that = (RouteMessageResponseHandler)o;
        return this.completableFuture.equals(that.completableFuture);
    }

    public int hashCode() {
        return Objects.hash(this.completableFuture);
    }
}

