/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.exceptions.SessionExpiredException;
import org.neo4j.driver.exceptions.TransientException;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.GqlStatusError;
import org.neo4j.driver.internal.RoutingErrorHandler;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.Futures;

public class RoutingResponseHandler
implements ResponseHandler {
    private final ResponseHandler delegate;
    private final BoltServerAddress address;
    private final AccessMode accessMode;
    private final RoutingErrorHandler errorHandler;

    public RoutingResponseHandler(ResponseHandler delegate, BoltServerAddress address, AccessMode accessMode, RoutingErrorHandler errorHandler) {
        this.delegate = delegate;
        this.address = address;
        this.accessMode = accessMode;
        this.errorHandler = errorHandler;
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        this.delegate.onSuccess(metadata);
    }

    @Override
    public void onFailure(Throwable error) {
        Throwable newError = this.handledError(error);
        this.delegate.onFailure(newError);
    }

    @Override
    public void onRecord(Value[] fields) {
        this.delegate.onRecord(fields);
    }

    @Override
    public boolean canManageAutoRead() {
        return this.delegate.canManageAutoRead();
    }

    @Override
    public void disableAutoReadManagement() {
        this.delegate.disableAutoReadManagement();
    }

    private Throwable handledError(Throwable receivedError) {
        Throwable error = Futures.completionExceptionCause(receivedError);
        if (error instanceof ServiceUnavailableException) {
            return this.handledServiceUnavailableException((ServiceUnavailableException)error);
        }
        if (error instanceof ClientException) {
            return this.handledClientException((ClientException)error);
        }
        if (error instanceof TransientException) {
            return this.handledTransientException((TransientException)error);
        }
        return error;
    }

    private Throwable handledServiceUnavailableException(ServiceUnavailableException e) {
        this.errorHandler.onConnectionFailure(this.address);
        return new SessionExpiredException(String.format("Server at %s is no longer available", this.address), e);
    }

    private Throwable handledTransientException(TransientException e) {
        String errorCode = e.code();
        if (Objects.equals(errorCode, "Neo.TransientError.General.DatabaseUnavailable")) {
            this.errorHandler.onConnectionFailure(this.address);
        }
        return e;
    }

    private Throwable handledClientException(ClientException e) {
        if (RoutingResponseHandler.isFailureToWrite(e)) {
            switch (this.accessMode) {
                case READ: {
                    String message = "Write queries cannot be performed in READ access mode.";
                    return new ClientException(GqlStatusError.UNKNOWN.getStatus(), GqlStatusError.UNKNOWN.getStatusDescription(message), "N/A", message, GqlStatusError.DIAGNOSTIC_RECORD, null);
                }
                case WRITE: {
                    this.errorHandler.onWriteFailure(this.address);
                    return new SessionExpiredException(String.format("Server at %s no longer accepts writes", this.address));
                }
            }
            throw new IllegalArgumentException(this.accessMode + " not supported.");
        }
        return e;
    }

    private static boolean isFailureToWrite(ClientException e) {
        String errorCode = e.code();
        return Objects.equals(errorCode, "Neo.ClientError.Cluster.NotALeader") || Objects.equals(errorCode, "Neo.ClientError.General.ForbiddenOnReadOnlyDatabase");
    }
}

