/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.v53;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import java.time.Clock;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.internal.BoltAgent;
import org.neo4j.driver.internal.GqlNotificationConfig;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.handlers.HelloV51ResponseHandler;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.messaging.BoltProtocolVersion;
import org.neo4j.driver.internal.messaging.request.HelloMessage;
import org.neo4j.driver.internal.messaging.v52.BoltProtocolV52;

public class BoltProtocolV53
extends BoltProtocolV52 {
    public static final BoltProtocolVersion VERSION = new BoltProtocolVersion(5, 3);
    public static final BoltProtocol INSTANCE = new BoltProtocolV53();

    @Override
    public void initializeChannel(String userAgent, BoltAgent boltAgent, AuthToken authToken, RoutingContext routingContext, ChannelPromise channelInitializedPromise, GqlNotificationConfig notificationConfig, Clock clock) {
        Neo4jException exception = this.verifyNotificationConfigSupported(notificationConfig);
        if (exception != null) {
            channelInitializedPromise.setFailure((Throwable)exception);
            return;
        }
        Channel channel = channelInitializedPromise.channel();
        HelloMessage message = routingContext.isServerRoutingEnabled() ? new HelloMessage(userAgent, boltAgent, Collections.emptyMap(), routingContext.toMap(), false, notificationConfig, this.useLegacyNotifications()) : new HelloMessage(userAgent, boltAgent, Collections.emptyMap(), null, false, notificationConfig, this.useLegacyNotifications());
        CompletableFuture<Void> helloFuture = new CompletableFuture<Void>();
        ChannelAttributes.setHelloStage(channel, helloFuture);
        ChannelAttributes.messageDispatcher(channel).enqueue(new HelloV51ResponseHandler(channel, helloFuture));
        channel.write((Object)message, channel.voidPromise());
        channelInitializedPromise.setSuccess();
    }

    @Override
    public BoltProtocolVersion version() {
        return VERSION;
    }
}

