/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.TransactionNestingException;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.reactive.RxUtils;
import org.neo4j.driver.internal.telemetry.ApiTelemetryWork;
import org.neo4j.driver.internal.telemetry.TelemetryApi;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.reactive.ReactiveResult;
import org.neo4j.driver.reactive.RxResult;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class AbstractReactiveSession<S> {
    protected final NetworkSession session;

    public AbstractReactiveSession(NetworkSession session) {
        this.session = session;
    }

    protected abstract S createTransaction(UnmanagedTransaction var1);

    protected abstract Publisher<Void> closeTransaction(S var1, boolean var2);

    Publisher<S> doBeginTransaction(TransactionConfig config, ApiTelemetryWork apiTelemetryWork) {
        return this.doBeginTransaction(config, null, apiTelemetryWork);
    }

    protected Publisher<S> doBeginTransaction(TransactionConfig config, String txType, ApiTelemetryWork apiTelemetryWork) {
        return RxUtils.createSingleItemPublisher(() -> {
            CompletableFuture txFuture = new CompletableFuture();
            this.session.beginTransactionAsync(config, txType, apiTelemetryWork).whenComplete((tx, completionError) -> {
                if (tx != null) {
                    txFuture.complete(this.createTransaction((UnmanagedTransaction)tx));
                } else {
                    this.releaseConnectionBeforeReturning(txFuture, (Throwable)completionError);
                }
            });
            return txFuture;
        }, () -> new IllegalStateException("Unexpected condition, begin transaction call has completed successfully with transaction being null"), tx -> Mono.fromDirect(this.closeTransaction(tx, false)).subscribe());
    }

    private Publisher<S> beginTransaction(AccessMode mode, TransactionConfig config, ApiTelemetryWork apiTelemetryWork) {
        return RxUtils.createSingleItemPublisher(() -> {
            CompletableFuture txFuture = new CompletableFuture();
            this.session.beginTransactionAsync(mode, config, apiTelemetryWork).whenComplete((tx, completionError) -> {
                if (tx != null) {
                    txFuture.complete(this.createTransaction((UnmanagedTransaction)tx));
                } else {
                    this.releaseConnectionBeforeReturning(txFuture, (Throwable)completionError);
                }
            });
            return txFuture;
        }, () -> new IllegalStateException("Unexpected condition, begin transaction call has completed successfully with transaction being null"), tx -> Mono.fromDirect(this.closeTransaction(tx, false)).subscribe());
    }

    protected <T> Publisher<T> runTransaction(AccessMode mode, Function<S, ? extends Publisher<T>> work, TransactionConfig config) {
        work = work.andThen(publisher -> Flux.from((Publisher)publisher).handle((value, sink) -> {
            if (value instanceof org.neo4j.driver.reactivestreams.ReactiveResult) {
                sink.error((Throwable)new ClientException(String.format("%s is not a valid return value, it should be consumed before producing a return value", org.neo4j.driver.reactivestreams.ReactiveResult.class.getName())));
                return;
            }
            if (value instanceof ReactiveResult) {
                sink.error((Throwable)new ClientException(String.format("%s is not a valid return value, it should be consumed before producing a return value", ReactiveResult.class.getName())));
                return;
            }
            if (value instanceof RxResult) {
                sink.error((Throwable)new ClientException(String.format("%s is not a valid return value, it should be consumed before producing a return value", RxResult.class.getName())));
                return;
            }
            sink.next(value);
        }));
        ApiTelemetryWork apiTelemetryWork = new ApiTelemetryWork(TelemetryApi.MANAGED_TRANSACTION);
        Flux repeatableWork = Flux.usingWhen(this.beginTransaction(mode, config, apiTelemetryWork), work, tx -> this.closeTransaction(tx, true), (tx, error) -> this.closeTransaction(tx, false), tx -> this.closeTransaction(tx, false));
        return this.session.retryLogic().retryRx(repeatableWork);
    }

    private <T> void releaseConnectionBeforeReturning(CompletableFuture<T> returnFuture, Throwable completionError) {
        Throwable error = Futures.completionExceptionCause(completionError);
        if (error instanceof TransactionNestingException) {
            returnFuture.completeExceptionally(error);
        } else {
            this.session.releaseConnectionAsync().whenComplete((ignored, closeError) -> returnFuture.completeExceptionally(Futures.combineErrors(error, closeError)));
        }
    }

    public Set<Bookmark> lastBookmarks() {
        return this.session.lastBookmarks();
    }

    protected <T> Publisher<T> run(Query query, TransactionConfig config, Function<RxResultCursor, T> cursorToResult) {
        CompletableFuture cursorPublishFuture = new CompletableFuture();
        AtomicReference cursorReference = new AtomicReference();
        return RxUtils.createSingleItemPublisher(() -> this.runAsStage(query, config, cursorPublishFuture).thenApply(cursor -> {
            cursorReference.set(cursor);
            return cursor;
        }).thenApply(cursorToResult), () -> new IllegalStateException("Unexpected condition, run call has completed successfully with result being null"), value -> {
            if (value != null) {
                ((RxResultCursor)cursorReference.get()).rollback().whenComplete((unused, throwable) -> {
                    if (throwable != null) {
                        cursorPublishFuture.completeExceptionally((Throwable)throwable);
                    } else {
                        cursorPublishFuture.complete(null);
                    }
                });
            }
        }).doOnNext(value -> cursorPublishFuture.complete((RxResultCursor)cursorReference.get())).doOnError(cursorPublishFuture::completeExceptionally);
    }

    private CompletionStage<RxResultCursor> runAsStage(Query query, TransactionConfig config, CompletionStage<RxResultCursor> finalStage) {
        CompletionStage<RxResultCursor> cursorStage;
        try {
            cursorStage = this.session.runRx(query, config, finalStage);
        }
        catch (Throwable t) {
            cursorStage = Futures.failedFuture(t);
        }
        return cursorStage.handle((cursor, throwable) -> {
            if (throwable != null) {
                return this.releaseConnectionAndRethrow((Throwable)throwable);
            }
            Throwable runError = cursor.getRunError();
            if (runError != null) {
                return this.releaseConnectionAndRethrow(runError);
            }
            return CompletableFuture.completedFuture(cursor);
        }).thenCompose(Function.identity());
    }

    private <T> CompletionStage<T> releaseConnectionAndRethrow(Throwable throwable) {
        return this.session.releaseConnectionAsync().handle((ignored, releaseThrowable) -> {
            if (releaseThrowable != null) {
                throw Futures.combineErrors(throwable, releaseThrowable);
            }
            if (throwable instanceof RuntimeException) {
                RuntimeException e = (RuntimeException)throwable;
                throw e;
            }
            throw new CompletionException(throwable);
        });
    }

    protected <T> Publisher<T> doClose() {
        return RxUtils.createEmptyPublisher(this.session::closeAsync);
    }
}

