/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.DatabaseNameUtil;
import org.neo4j.driver.internal.async.ConnectionContext;

public class ImmutableConnectionContext
implements ConnectionContext {
    private static final ConnectionContext SINGLE_DB_CONTEXT = new ImmutableConnectionContext(DatabaseNameUtil.defaultDatabase(), Collections.emptySet(), AccessMode.READ);
    private static final ConnectionContext MULTI_DB_CONTEXT = new ImmutableConnectionContext(DatabaseNameUtil.systemDatabase(), Collections.emptySet(), AccessMode.READ);
    private final CompletableFuture<DatabaseName> databaseNameFuture;
    private final AccessMode mode;
    private final Set<Bookmark> rediscoveryBookmarks;

    public ImmutableConnectionContext(DatabaseName databaseName, Set<Bookmark> bookmarks, AccessMode mode) {
        this.databaseNameFuture = CompletableFuture.completedFuture(databaseName);
        this.rediscoveryBookmarks = bookmarks;
        this.mode = mode;
    }

    @Override
    public CompletableFuture<DatabaseName> databaseNameFuture() {
        return this.databaseNameFuture;
    }

    @Override
    public AccessMode mode() {
        return this.mode;
    }

    @Override
    public Set<Bookmark> rediscoveryBookmarks() {
        return this.rediscoveryBookmarks;
    }

    @Override
    public String impersonatedUser() {
        return null;
    }

    public static ConnectionContext simple(boolean supportsMultiDb) {
        return supportsMultiDb ? MULTI_DB_CONTEXT : SINGLE_DB_CONTEXT;
    }
}

