/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.TransactionCallback;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.TransactionWork;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.internal.AbstractQueryRunner;
import org.neo4j.driver.internal.DelegatingTransactionContext;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.InternalResult;
import org.neo4j.driver.internal.InternalTransaction;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Futures;

public class InternalSession
extends AbstractQueryRunner
implements Session {
    private final NetworkSession session;

    public InternalSession(NetworkSession session) {
        this.session = session;
    }

    @Override
    public Result run(Query query) {
        return this.run(query, TransactionConfig.empty());
    }

    @Override
    public Result run(String query, TransactionConfig config) {
        return this.run(query, Collections.emptyMap(), config);
    }

    @Override
    public Result run(String query, Map<String, Object> parameters, TransactionConfig config) {
        return this.run(new Query(query, parameters), config);
    }

    @Override
    public Result run(Query query, TransactionConfig config) {
        ResultCursor cursor = Futures.blockingGet(this.session.runAsync(query, config), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while running query in session"));
        Connection connection = Futures.getNow(this.session.connectionAsync());
        return new InternalResult(connection, cursor);
    }

    @Override
    public boolean isOpen() {
        return this.session.isOpen();
    }

    @Override
    public void close() {
        Futures.blockingGet(this.session.closeAsync(), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while closing the session"));
    }

    @Override
    public Transaction beginTransaction() {
        return this.beginTransaction(TransactionConfig.empty());
    }

    @Override
    public Transaction beginTransaction(TransactionConfig config) {
        UnmanagedTransaction tx = Futures.blockingGet(this.session.beginTransactionAsync(config), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while starting a transaction"));
        return new InternalTransaction(tx);
    }

    @Override
    @Deprecated
    public <T> T readTransaction(TransactionWork<T> work) {
        return this.readTransaction(work, TransactionConfig.empty());
    }

    @Override
    @Deprecated
    public <T> T readTransaction(TransactionWork<T> work, TransactionConfig config) {
        return this.transaction(AccessMode.READ, work, config);
    }

    @Override
    public <T> T executeRead(TransactionCallback<T> callback, TransactionConfig config) {
        return (T)this.readTransaction(tx -> callback.execute(new DelegatingTransactionContext(tx)), config);
    }

    @Override
    @Deprecated
    public <T> T writeTransaction(TransactionWork<T> work) {
        return this.writeTransaction(work, TransactionConfig.empty());
    }

    @Override
    @Deprecated
    public <T> T writeTransaction(TransactionWork<T> work, TransactionConfig config) {
        return this.transaction(AccessMode.WRITE, work, config);
    }

    @Override
    public <T> T executeWrite(TransactionCallback<T> callback, TransactionConfig config) {
        return (T)this.writeTransaction(tx -> callback.execute(new DelegatingTransactionContext(tx)), config);
    }

    @Override
    @Deprecated
    public Bookmark lastBookmark() {
        return InternalBookmark.from(this.session.lastBookmarks());
    }

    @Override
    public Set<Bookmark> lastBookmarks() {
        return this.session.lastBookmarks();
    }

    private <T> T transaction(AccessMode mode, TransactionWork<T> work, TransactionConfig config) {
        return (T)this.session.retryLogic().retry(() -> {
            try (Transaction tx = this.beginTransaction(mode, config);){
                Object result = work.execute(tx);
                if (tx.isOpen()) {
                    tx.commit();
                }
                Object t = result;
                return t;
            }
        });
    }

    private Transaction beginTransaction(AccessMode mode, TransactionConfig config) {
        UnmanagedTransaction tx = Futures.blockingGet(this.session.beginTransactionAsync(mode, config), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while starting a transaction"));
        return new InternalTransaction(tx);
    }

    private void terminateConnectionOnThreadInterrupt(String reason) {
        Connection connection = null;
        try {
            connection = Futures.getNow(this.session.connectionAsync());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (connection != null) {
            connection.terminateAndRelease(reason);
        }
    }
}

