/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.driver.NotificationCategory;

public record InternalNotificationCategory(Type type) implements NotificationCategory
{
    public InternalNotificationCategory {
        Objects.requireNonNull(type, "type must not be null");
    }

    public static Optional<NotificationCategory> valueOf(String value) {
        return Arrays.stream(Type.values()).filter(type -> type.toString().equals(value)).findFirst().map(type -> switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case Type.HINT -> NotificationCategory.HINT;
            case Type.UNRECOGNIZED -> NotificationCategory.UNRECOGNIZED;
            case Type.UNSUPPORTED -> NotificationCategory.UNSUPPORTED;
            case Type.PERFORMANCE -> NotificationCategory.PERFORMANCE;
            case Type.DEPRECATION -> NotificationCategory.DEPRECATION;
            case Type.SECURITY -> NotificationCategory.SECURITY;
            case Type.TOPOLOGY -> NotificationCategory.TOPOLOGY;
            case Type.GENERIC -> NotificationCategory.GENERIC;
        });
    }

    public static enum Type {
        HINT,
        UNRECOGNIZED,
        UNSUPPORTED,
        PERFORMANCE,
        DEPRECATION,
        SECURITY,
        TOPOLOGY,
        GENERIC;

    }
}

