/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.reactive;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.Flow;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.reactive.ReactiveQueryRunner;
import org.neo4j.driver.reactive.ReactiveResult;
import org.neo4j.driver.reactive.ReactiveTransaction;
import org.neo4j.driver.reactive.ReactiveTransactionCallback;

public interface ReactiveSession
extends ReactiveQueryRunner {
    default public Flow.Publisher<ReactiveTransaction> beginTransaction() {
        return this.beginTransaction(TransactionConfig.empty());
    }

    public Flow.Publisher<ReactiveTransaction> beginTransaction(TransactionConfig var1);

    default public <T> Flow.Publisher<T> executeRead(ReactiveTransactionCallback<? extends Flow.Publisher<T>> callback) {
        return this.executeRead(callback, TransactionConfig.empty());
    }

    public <T> Flow.Publisher<T> executeRead(ReactiveTransactionCallback<? extends Flow.Publisher<T>> var1, TransactionConfig var2);

    default public <T> Flow.Publisher<T> executeWrite(ReactiveTransactionCallback<? extends Flow.Publisher<T>> callback) {
        return this.executeWrite(callback, TransactionConfig.empty());
    }

    public <T> Flow.Publisher<T> executeWrite(ReactiveTransactionCallback<? extends Flow.Publisher<T>> var1, TransactionConfig var2);

    default public Flow.Publisher<ReactiveResult> run(String query, TransactionConfig config) {
        return this.run(new Query(query), config);
    }

    default public Flow.Publisher<ReactiveResult> run(String query, Map<String, Object> parameters, TransactionConfig config) {
        return this.run(new Query(query, parameters), config);
    }

    public Flow.Publisher<ReactiveResult> run(Query var1, TransactionConfig var2);

    public Set<Bookmark> lastBookmarks();

    public <T> Flow.Publisher<T> close();
}

