/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import java.util.List;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.neo4j.driver.Record;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.util.ErrorUtil;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.reactive.RxResult;
import org.neo4j.driver.summary.ResultSummary;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.Mono;

public class InternalRxResult
implements RxResult {
    private Supplier<CompletionStage<RxResultCursor>> cursorFutureSupplier;
    private volatile CompletionStage<RxResultCursor> cursorFuture;

    public InternalRxResult(Supplier<CompletionStage<RxResultCursor>> cursorFuture) {
        this.cursorFutureSupplier = cursorFuture;
    }

    @Override
    public Publisher<List<String>> keys() {
        return Mono.defer(() -> Mono.fromCompletionStage(this.getCursorFuture()).map(RxResultCursor::keys).onErrorMap(Futures::completionExceptionCause));
    }

    @Override
    public Publisher<Record> records() {
        return Flux.create(sink -> this.getCursorFuture().whenComplete((cursor, completionError) -> {
            if (cursor != null) {
                if (cursor.isDone()) {
                    sink.error((Throwable)ErrorUtil.newResultConsumedError());
                } else {
                    cursor.installRecordConsumer(this.createRecordConsumer((FluxSink<Record>)sink));
                    sink.onCancel(() -> ((RxResultCursor)cursor).cancel());
                    sink.onRequest(arg_0 -> ((RxResultCursor)cursor).request(arg_0));
                }
            } else {
                Throwable error = Futures.completionExceptionCause(completionError);
                sink.error(error);
            }
        }), (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.IGNORE);
    }

    private BiConsumer<Record, Throwable> createRecordConsumer(FluxSink<Record> sink) {
        return (r, e) -> {
            if (r != null) {
                sink.next(r);
            } else if (e != null) {
                sink.error(e);
            } else {
                sink.complete();
            }
        };
    }

    private CompletionStage<RxResultCursor> getCursorFuture() {
        if (this.cursorFuture != null) {
            return this.cursorFuture;
        }
        return this.initCursorFuture();
    }

    synchronized CompletionStage<RxResultCursor> initCursorFuture() {
        if (this.cursorFuture != null) {
            return this.cursorFuture;
        }
        this.cursorFuture = this.cursorFutureSupplier.get();
        this.cursorFutureSupplier = null;
        return this.cursorFuture;
    }

    @Override
    public Publisher<ResultSummary> consume() {
        return Mono.create(sink -> this.getCursorFuture().whenComplete((cursor, completionError) -> {
            if (cursor != null) {
                cursor.summaryAsync().whenComplete((summary, summaryCompletionError) -> {
                    Throwable error = Futures.completionExceptionCause(summaryCompletionError);
                    if (summary != null) {
                        sink.success(summary);
                    } else {
                        sink.error(error);
                    }
                });
            } else {
                Throwable error = Futures.completionExceptionCause(completionError);
                sink.error(error);
            }
        }));
    }

    @Override
    public Publisher<Boolean> isOpen() {
        return Mono.fromCompletionStage(this.getCursorFuture()).map(cursor -> !cursor.isDone());
    }

    Supplier<CompletionStage<RxResultCursor>> cursorFutureSupplier() {
        return this.cursorFutureSupplier;
    }
}

