/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import java.util.Map;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.util.Extract;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.driver.reactive.ReactiveQueryRunner;
import org.neo4j.driver.reactive.ReactiveResult;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

interface BaseReactiveQueryRunner
extends ReactiveQueryRunner {
    @Override
    default public Publisher<ReactiveResult> run(String queryStr, Value parameters) {
        try {
            Query query = new Query(queryStr, parameters);
            return this.run(query);
        }
        catch (Throwable t) {
            return Mono.error((Throwable)t);
        }
    }

    @Override
    default public Publisher<ReactiveResult> run(String query, Map<String, Object> parameters) {
        return this.run(query, BaseReactiveQueryRunner.parameters(parameters));
    }

    @Override
    default public Publisher<ReactiveResult> run(String query, Record parameters) {
        return this.run(query, BaseReactiveQueryRunner.parameters(parameters));
    }

    @Override
    default public Publisher<ReactiveResult> run(String queryStr) {
        try {
            Query query = new Query(queryStr);
            return this.run(query);
        }
        catch (Throwable t) {
            return Mono.error((Throwable)t);
        }
    }

    public static Value parameters(Record record) {
        return record == null ? Values.EmptyMap : BaseReactiveQueryRunner.parameters(record.asMap());
    }

    public static Value parameters(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return Values.EmptyMap;
        }
        return new MapValue(Extract.mapOfValues(map));
    }
}

