/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.common;

import java.io.IOException;
import java.util.Map;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.ResponseMessageHandler;
import org.neo4j.driver.internal.messaging.ValueUnpacker;
import org.neo4j.driver.internal.messaging.common.CommonValueUnpacker;
import org.neo4j.driver.internal.packstream.PackInput;

public class CommonMessageReader
implements MessageFormat.Reader {
    private final ValueUnpacker unpacker;

    public CommonMessageReader(PackInput input, boolean dateTimeUtcEnabled) {
        this(new CommonValueUnpacker(input, dateTimeUtcEnabled));
    }

    protected CommonMessageReader(ValueUnpacker unpacker) {
        this.unpacker = unpacker;
    }

    @Override
    public void read(ResponseMessageHandler handler) throws IOException {
        this.unpacker.unpackStructHeader();
        int type = this.unpacker.unpackStructSignature();
        switch (type) {
            case 112: {
                this.unpackSuccessMessage(handler);
                break;
            }
            case 127: {
                this.unpackFailureMessage(handler);
                break;
            }
            case 126: {
                this.unpackIgnoredMessage(handler);
                break;
            }
            case 113: {
                this.unpackRecordMessage(handler);
                break;
            }
            default: {
                throw new IOException("Unknown message type: " + type);
            }
        }
    }

    private void unpackSuccessMessage(ResponseMessageHandler output) throws IOException {
        Map<String, Value> map = this.unpacker.unpackMap();
        output.handleSuccessMessage(map);
    }

    private void unpackFailureMessage(ResponseMessageHandler output) throws IOException {
        Map<String, Value> params = this.unpacker.unpackMap();
        String code = params.get("code").asString();
        String message = params.get("message").asString();
        output.handleFailureMessage(code, message);
    }

    private void unpackIgnoredMessage(ResponseMessageHandler output) throws IOException {
        output.handleIgnoredMessage();
    }

    private void unpackRecordMessage(ResponseMessageHandler output) throws IOException {
        Value[] fields = this.unpacker.unpackArray();
        output.handleRecordMessage(fields);
    }
}

