/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.exceptions.TransactionNestingException;
import org.neo4j.driver.internal.async.NetworkSession;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.reactive.AbstractRxQueryRunner;
import org.neo4j.driver.internal.reactive.InternalRxResult;
import org.neo4j.driver.internal.reactive.InternalRxTransaction;
import org.neo4j.driver.internal.reactive.RxUtils;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Flux;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.reactive.RxResult;
import org.neo4j.driver.reactive.RxSession;
import org.neo4j.driver.reactive.RxTransaction;
import org.neo4j.driver.reactive.RxTransactionWork;
import org.reactivestreams.Publisher;

public class InternalRxSession
extends AbstractRxQueryRunner
implements RxSession {
    private final NetworkSession session;

    public InternalRxSession(NetworkSession session) {
        this.session = session;
    }

    @Override
    public Publisher<RxTransaction> beginTransaction() {
        return this.beginTransaction(TransactionConfig.empty());
    }

    @Override
    public Publisher<RxTransaction> beginTransaction(TransactionConfig config) {
        return RxUtils.createSingleItemPublisher(() -> {
            CompletableFuture txFuture = new CompletableFuture();
            this.session.beginTransactionAsync(config).whenComplete((tx, completionError) -> {
                if (tx != null) {
                    txFuture.complete(new InternalRxTransaction((UnmanagedTransaction)tx));
                } else {
                    this.releaseConnectionBeforeReturning(txFuture, (Throwable)completionError);
                }
            });
            return txFuture;
        }, () -> new IllegalStateException("Unexpected condition, begin transaction call has completed successfully with transaction being null"));
    }

    private Publisher<InternalRxTransaction> beginTransaction(AccessMode mode, TransactionConfig config) {
        return RxUtils.createSingleItemPublisher(() -> {
            CompletableFuture txFuture = new CompletableFuture();
            this.session.beginTransactionAsync(mode, config).whenComplete((tx, completionError) -> {
                if (tx != null) {
                    txFuture.complete(new InternalRxTransaction((UnmanagedTransaction)tx));
                } else {
                    this.releaseConnectionBeforeReturning(txFuture, (Throwable)completionError);
                }
            });
            return txFuture;
        }, () -> new IllegalStateException("Unexpected condition, begin transaction call has completed successfully with transaction being null"));
    }

    @Override
    public <T> Publisher<T> readTransaction(RxTransactionWork<? extends Publisher<T>> work) {
        return this.readTransaction(work, TransactionConfig.empty());
    }

    @Override
    public <T> Publisher<T> readTransaction(RxTransactionWork<? extends Publisher<T>> work, TransactionConfig config) {
        return this.runTransaction(AccessMode.READ, work, config);
    }

    @Override
    public <T> Publisher<T> writeTransaction(RxTransactionWork<? extends Publisher<T>> work) {
        return this.writeTransaction(work, TransactionConfig.empty());
    }

    @Override
    public <T> Publisher<T> writeTransaction(RxTransactionWork<? extends Publisher<T>> work, TransactionConfig config) {
        return this.runTransaction(AccessMode.WRITE, work, config);
    }

    private <T> Publisher<T> runTransaction(AccessMode mode, RxTransactionWork<? extends Publisher<T>> work, TransactionConfig config) {
        Flux repeatableWork = Flux.usingWhen(this.beginTransaction(mode, config), work::execute, InternalRxTransaction::commitIfOpen, (tx, error) -> tx.close(), null);
        return this.session.retryLogic().retryRx(repeatableWork);
    }

    @Override
    public RxResult run(String query, TransactionConfig config) {
        return this.run(new Query(query), config);
    }

    @Override
    public RxResult run(String query, Map<String, Object> parameters, TransactionConfig config) {
        return this.run(new Query(query, parameters), config);
    }

    @Override
    public RxResult run(Query query) {
        return this.run(query, TransactionConfig.empty());
    }

    @Override
    public RxResult run(Query query, TransactionConfig config) {
        return new InternalRxResult(() -> {
            CompletableFuture resultCursorFuture = new CompletableFuture();
            this.session.runRx(query, config).whenComplete((cursor, completionError) -> {
                if (cursor != null) {
                    resultCursorFuture.complete(cursor);
                } else {
                    this.releaseConnectionBeforeReturning(resultCursorFuture, (Throwable)completionError);
                }
            });
            return resultCursorFuture;
        });
    }

    private <T> void releaseConnectionBeforeReturning(CompletableFuture<T> returnFuture, Throwable completionError) {
        Throwable error = Futures.completionExceptionCause(completionError);
        if (error instanceof TransactionNestingException) {
            returnFuture.completeExceptionally(error);
        } else {
            this.session.releaseConnectionAsync().whenComplete((ignored, closeError) -> returnFuture.completeExceptionally(Futures.combineErrors(error, closeError)));
        }
    }

    @Override
    public Bookmark lastBookmark() {
        return this.session.lastBookmark();
    }

    public Publisher<Void> reset() {
        return RxUtils.createEmptyPublisher(this.session::resetAsync);
    }

    @Override
    public <T> Publisher<T> close() {
        return RxUtils.createEmptyPublisher(this.session::closeAsync);
    }
}

