/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.async.connection.DirectConnection;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.cluster.RoutingProcedureResponse;
import org.neo4j.driver.internal.cluster.RoutingProcedureRunner;
import org.neo4j.driver.internal.handlers.RouteMessageResponseHandler;
import org.neo4j.driver.internal.messaging.request.RouteMessage;
import org.neo4j.driver.internal.spi.Connection;

public class RouteMessageRoutingProcedureRunner
implements RoutingProcedureRunner {
    private final Map<String, Value> routingContext;
    private final Supplier<CompletableFuture<Map<String, Value>>> createCompletableFuture;

    public RouteMessageRoutingProcedureRunner(RoutingContext routingContext) {
        this(routingContext, CompletableFuture::new);
    }

    protected RouteMessageRoutingProcedureRunner(RoutingContext routingContext, Supplier<CompletableFuture<Map<String, Value>>> createCompletableFuture) {
        this.routingContext = routingContext.toMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> Values.value((String)entry.getValue())));
        this.createCompletableFuture = createCompletableFuture;
    }

    @Override
    public CompletionStage<RoutingProcedureResponse> run(Connection connection, DatabaseName databaseName, Bookmark bookmark) {
        CompletableFuture<Map<String, Value>> completableFuture = this.createCompletableFuture.get();
        DirectConnection directConnection = this.toDirectConnection(connection, databaseName);
        directConnection.writeAndFlush(new RouteMessage(this.routingContext, bookmark, databaseName.databaseName().orElse(null)), new RouteMessageResponseHandler(completableFuture));
        return ((CompletableFuture)((CompletableFuture)completableFuture.thenApply(routingTable -> new RoutingProcedureResponse(this.getQuery(databaseName), Collections.singletonList(this.toRecord((Map<String, Value>)routingTable))))).exceptionally(throwable -> new RoutingProcedureResponse(this.getQuery(databaseName), throwable.getCause()))).thenCompose(routingProcedureResponse -> directConnection.release().thenApply(ignore -> routingProcedureResponse));
    }

    private Record toRecord(Map<String, Value> routingTable) {
        return new InternalRecord(new ArrayList<String>(routingTable.keySet()), routingTable.values().toArray(new Value[0]));
    }

    private DirectConnection toDirectConnection(Connection connection, DatabaseName databaseName) {
        return new DirectConnection(connection, databaseName, AccessMode.READ);
    }

    private Query getQuery(DatabaseName databaseName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("routingContext", this.routingContext);
        params.put("databaseName", databaseName.databaseName().orElse(null));
        return new Query("ROUTE $routingContext $databaseName", params);
    }
}

