/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging;

import java.util.concurrent.CompletionStage;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.cursor.ResultCursorFactory;
import org.neo4j.driver.internal.messaging.BoltProtocolVersion;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.v3.BoltProtocolV3;
import org.neo4j.driver.internal.messaging.v4.BoltProtocolV4;
import org.neo4j.driver.internal.messaging.v41.BoltProtocolV41;
import org.neo4j.driver.internal.messaging.v42.BoltProtocolV42;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPromise;
import org.neo4j.driver.internal.spi.Connection;

public interface BoltProtocol {
    public MessageFormat createMessageFormat();

    public void initializeChannel(String var1, AuthToken var2, RoutingContext var3, ChannelPromise var4);

    public void prepareToCloseChannel(Channel var1);

    public CompletionStage<Void> beginTransaction(Connection var1, Bookmark var2, TransactionConfig var3);

    public CompletionStage<Bookmark> commitTransaction(Connection var1);

    public CompletionStage<Void> rollbackTransaction(Connection var1);

    public ResultCursorFactory runInAutoCommitTransaction(Connection var1, Query var2, BookmarkHolder var3, TransactionConfig var4, boolean var5, long var6);

    public ResultCursorFactory runInUnmanagedTransaction(Connection var1, Query var2, UnmanagedTransaction var3, boolean var4, long var5);

    public BoltProtocolVersion version();

    public static BoltProtocol forChannel(Channel channel) {
        return BoltProtocol.forVersion(ChannelAttributes.protocolVersion(channel));
    }

    public static BoltProtocol forVersion(BoltProtocolVersion version) {
        if (BoltProtocolV3.VERSION.equals(version)) {
            return BoltProtocolV3.INSTANCE;
        }
        if (BoltProtocolV4.VERSION.equals(version)) {
            return BoltProtocolV4.INSTANCE;
        }
        if (BoltProtocolV41.VERSION.equals(version)) {
            return BoltProtocolV41.INSTANCE;
        }
        if (BoltProtocolV42.VERSION.equals(version)) {
            return BoltProtocolV42.INSTANCE;
        }
        throw new ClientException("Unknown protocol version: " + version);
    }
}

