/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.connection;

import java.util.concurrent.ThreadFactory;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.EventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.nio.NioEventLoopGroup;
import org.neo4j.driver.internal.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.FastThreadLocalThread;

public final class EventLoopGroupFactory {
    private static final String THREAD_NAME_PREFIX = "Neo4jDriverIO";
    private static final int THREAD_PRIORITY = 10;

    private EventLoopGroupFactory() {
    }

    public static Class<? extends Channel> channelClass() {
        return NioSocketChannel.class;
    }

    public static EventLoopGroup newEventLoopGroup(int threadCount) {
        return new DriverEventLoopGroup(threadCount);
    }

    public static void assertNotInEventLoopThread() throws IllegalStateException {
        if (EventLoopGroupFactory.isEventLoopThread(Thread.currentThread())) {
            throw new IllegalStateException("Blocking operation can't be executed in IO thread because it might result in a deadlock. Please do not use blocking API when chaining futures returned by async API methods.");
        }
    }

    public static boolean isEventLoopThread(Thread thread) {
        return thread instanceof DriverThread;
    }

    private static class DriverThread
    extends FastThreadLocalThread {
        DriverThread(ThreadGroup group, Runnable target, String name) {
            super(group, target, name);
        }
    }

    private static class DriverThreadFactory
    extends DefaultThreadFactory {
        DriverThreadFactory() {
            super(EventLoopGroupFactory.THREAD_NAME_PREFIX, 10);
        }

        @Override
        protected Thread newThread(Runnable r, String name) {
            return new DriverThread(this.threadGroup, r, name);
        }
    }

    private static class DriverEventLoopGroup
    extends NioEventLoopGroup {
        DriverEventLoopGroup() {
        }

        DriverEventLoopGroup(int nThreads) {
            super(nThreads);
        }

        @Override
        protected ThreadFactory newDefaultThreadFactory() {
            return new DriverThreadFactory();
        }
    }
}

