/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.util.context;

import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Stream;
import org.neo4j.driver.internal.shaded.reactor.util.context.Context;
import org.neo4j.driver.internal.shaded.reactor.util.context.Context2;

final class Context1
implements Context,
Map.Entry<Object, Object> {
    final Object key;
    final Object value;

    Context1(Object key, Object value) {
        this.key = Objects.requireNonNull(key, "key");
        this.value = Objects.requireNonNull(value, "value");
    }

    @Override
    public Context put(Object key, Object value) {
        Objects.requireNonNull(key, "key");
        Objects.requireNonNull(value, "value");
        if (this.key.equals(key)) {
            return new Context1(key, value);
        }
        return new Context2(this.key, this.value, key, value);
    }

    @Override
    public Context delete(Object key) {
        Objects.requireNonNull(key, "key");
        if (this.key.equals(key)) {
            return Context.empty();
        }
        return this;
    }

    @Override
    public boolean hasKey(Object key) {
        return this.key.equals(key);
    }

    @Override
    public <T> T get(Object key) {
        if (this.hasKey(key)) {
            return (T)this.value;
        }
        throw new NoSuchElementException("Context does not contain key: " + key);
    }

    @Override
    public Stream<Map.Entry<Object, Object>> stream() {
        return Stream.of(this);
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Object setValue(Object value) {
        throw new UnsupportedOperationException("Does not support in-place update");
    }

    @Override
    public int size() {
        return 1;
    }

    public String toString() {
        return "Context1{" + this.key + '=' + this.value + '}';
    }
}

