/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.Query;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.reactive.AbstractRxQueryRunner;
import org.neo4j.driver.internal.reactive.InternalRxResult;
import org.neo4j.driver.internal.reactive.RxUtils;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.reactive.RxResult;
import org.neo4j.driver.reactive.RxTransaction;
import org.reactivestreams.Publisher;

public class InternalRxTransaction
extends AbstractRxQueryRunner
implements RxTransaction {
    private final UnmanagedTransaction tx;

    public InternalRxTransaction(UnmanagedTransaction tx) {
        this.tx = tx;
    }

    @Override
    public RxResult run(Query query) {
        return new InternalRxResult(() -> {
            CompletableFuture cursorFuture = new CompletableFuture();
            this.tx.runRx(query).whenComplete((cursor, completionError) -> {
                if (cursor != null) {
                    cursorFuture.complete(cursor);
                } else {
                    Throwable error = Futures.completionExceptionCause(completionError);
                    this.tx.markTerminated();
                    cursorFuture.completeExceptionally(error);
                }
            });
            return cursorFuture;
        });
    }

    @Override
    public <T> Publisher<T> commit() {
        return this.close(true);
    }

    @Override
    public <T> Publisher<T> rollback() {
        return this.close(false);
    }

    private <T> Publisher<T> close(boolean commit) {
        return RxUtils.createEmptyPublisher(() -> {
            if (commit) {
                return this.tx.commitAsync();
            }
            return this.tx.rollbackAsync();
        });
    }
}

