/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers.pulln;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.neo4j.driver.Query;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.handlers.PullResponseCompletionListener;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.PullResponseHandler;
import org.neo4j.driver.internal.messaging.request.DiscardMessage;
import org.neo4j.driver.internal.messaging.request.PullMessage;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.MetadataExtractor;
import org.neo4j.driver.internal.value.BooleanValue;
import org.neo4j.driver.summary.ResultSummary;

public class BasicPullResponseHandler
implements PullResponseHandler {
    private final Query query;
    protected final RunResponseHandler runResponseHandler;
    protected final MetadataExtractor metadataExtractor;
    protected final Connection connection;
    private final PullResponseCompletionListener completionListener;
    private PullResponseHandler.Status status = PullResponseHandler.Status.READY;
    private long toRequest;
    private BiConsumer<Record, Throwable> recordConsumer = null;
    private BiConsumer<ResultSummary, Throwable> summaryConsumer = null;

    public BasicPullResponseHandler(Query query, RunResponseHandler runResponseHandler, Connection connection, MetadataExtractor metadataExtractor, PullResponseCompletionListener completionListener) {
        this.query = Objects.requireNonNull(query);
        this.runResponseHandler = Objects.requireNonNull(runResponseHandler);
        this.metadataExtractor = Objects.requireNonNull(metadataExtractor);
        this.connection = Objects.requireNonNull(connection);
        this.completionListener = Objects.requireNonNull(completionListener);
    }

    @Override
    public synchronized void onSuccess(Map<String, Value> metadata) {
        this.assertRecordAndSummaryConsumerInstalled();
        if (metadata.getOrDefault("has_more", BooleanValue.FALSE).asBoolean()) {
            this.handleSuccessWithHasMore();
        } else {
            this.handleSuccessWithSummary(metadata);
        }
    }

    @Override
    public synchronized void onFailure(Throwable error) {
        this.assertRecordAndSummaryConsumerInstalled();
        this.status = PullResponseHandler.Status.FAILED;
        this.completionListener.afterFailure(error);
        this.complete(this.extractResultSummary(Collections.emptyMap()), error);
    }

    @Override
    public synchronized void onRecord(Value[] fields) {
        this.assertRecordAndSummaryConsumerInstalled();
        if (this.isStreaming()) {
            InternalRecord record = new InternalRecord(this.runResponseHandler.queryKeys(), fields);
            this.recordConsumer.accept(record, null);
        }
    }

    public synchronized void request(long size) {
        this.assertRecordAndSummaryConsumerInstalled();
        if (this.isStreamingPaused()) {
            this.status = PullResponseHandler.Status.STREAMING;
            this.connection.writeAndFlush(new PullMessage(size, this.runResponseHandler.queryId()), this);
        } else if (this.isStreaming()) {
            this.addToRequest(size);
        }
    }

    public synchronized void cancel() {
        this.assertRecordAndSummaryConsumerInstalled();
        if (this.isStreamingPaused()) {
            this.status = PullResponseHandler.Status.CANCELED;
            this.connection.writeAndFlush(DiscardMessage.newDiscardAllMessage(this.runResponseHandler.queryId()), this);
        } else if (this.isStreaming()) {
            this.status = PullResponseHandler.Status.CANCELED;
        }
    }

    @Override
    public synchronized void installSummaryConsumer(BiConsumer<ResultSummary, Throwable> summaryConsumer) {
        if (this.summaryConsumer != null) {
            throw new IllegalStateException("Summary consumer already installed.");
        }
        this.summaryConsumer = summaryConsumer;
    }

    @Override
    public synchronized void installRecordConsumer(BiConsumer<Record, Throwable> recordConsumer) {
        if (this.recordConsumer != null) {
            throw new IllegalStateException("Record consumer already installed.");
        }
        this.recordConsumer = recordConsumer;
    }

    private boolean isStreaming() {
        return this.status == PullResponseHandler.Status.STREAMING;
    }

    private boolean isStreamingPaused() {
        return this.status == PullResponseHandler.Status.READY;
    }

    protected boolean isDone() {
        return this.status == PullResponseHandler.Status.SUCCEEDED || this.status == PullResponseHandler.Status.FAILED;
    }

    private void handleSuccessWithSummary(Map<String, Value> metadata) {
        this.status = PullResponseHandler.Status.SUCCEEDED;
        this.completionListener.afterSuccess(metadata);
        ResultSummary summary = this.extractResultSummary(metadata);
        this.complete(summary, null);
    }

    private void handleSuccessWithHasMore() {
        if (this.status == PullResponseHandler.Status.CANCELED) {
            this.status = PullResponseHandler.Status.READY;
            this.cancel();
        } else if (this.status == PullResponseHandler.Status.STREAMING) {
            this.status = PullResponseHandler.Status.READY;
            if (this.toRequest > 0L || this.toRequest == -1L) {
                this.request(this.toRequest);
                this.toRequest = 0L;
            }
            this.summaryConsumer.accept(null, null);
        }
    }

    private ResultSummary extractResultSummary(Map<String, Value> metadata) {
        long resultAvailableAfter = this.runResponseHandler.resultAvailableAfter();
        return this.metadataExtractor.extractSummary(this.query, this.connection, resultAvailableAfter, metadata);
    }

    private void addToRequest(long toAdd) {
        if (this.toRequest == -1L) {
            return;
        }
        if (toAdd == -1L) {
            this.toRequest = -1L;
            return;
        }
        if (toAdd <= 0L) {
            throw new IllegalArgumentException("Cannot request record amount that is less than or equal to 0. Request amount: " + toAdd);
        }
        this.toRequest += toAdd;
        if (this.toRequest <= 0L) {
            this.toRequest = Long.MAX_VALUE;
        }
    }

    private void assertRecordAndSummaryConsumerInstalled() {
        if (this.isDone()) {
            return;
        }
        if (this.recordConsumer == null || this.summaryConsumer == null) {
            throw new IllegalStateException(String.format("Access record stream without record consumer and/or summary consumer. Record consumer=%s, Summary consumer=%s", this.recordConsumer, this.summaryConsumer));
        }
    }

    private void complete(ResultSummary summary, Throwable error) {
        this.summaryConsumer.accept(summary, error);
        this.recordConsumer.accept(null, error);
        this.dispose();
    }

    private void dispose() {
        this.recordConsumer = null;
        this.summaryConsumer = null;
    }

    protected PullResponseHandler.Status status() {
        return this.status;
    }

    protected void status(PullResponseHandler.Status status) {
        this.status = status;
    }
}

