/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import org.neo4j.driver.Statement;
import org.neo4j.driver.StatementResult;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.async.StatementResultCursor;
import org.neo4j.driver.internal.AbstractStatementRunner;
import org.neo4j.driver.internal.InternalStatementResult;
import org.neo4j.driver.internal.async.ExplicitTransaction;
import org.neo4j.driver.internal.util.Futures;

public class InternalTransaction
extends AbstractStatementRunner
implements Transaction {
    private final ExplicitTransaction tx;

    public InternalTransaction(ExplicitTransaction tx) {
        this.tx = tx;
    }

    @Override
    public void commit() {
        Futures.blockingGet(this.tx.commitAsync(), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while committing the transaction"));
    }

    @Override
    public void rollback() {
        Futures.blockingGet(this.tx.rollbackAsync(), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while rolling back the transaction"));
    }

    @Override
    public void close() {
        Futures.blockingGet(this.tx.closeAsync(), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while closing the transaction"));
    }

    @Override
    public StatementResult run(Statement statement) {
        StatementResultCursor cursor = Futures.blockingGet(this.tx.runAsync(statement, false), () -> this.terminateConnectionOnThreadInterrupt("Thread interrupted while running query in transaction"));
        return new InternalStatementResult(this.tx.connection(), cursor);
    }

    @Override
    public boolean isOpen() {
        return this.tx.isOpen();
    }

    private void terminateConnectionOnThreadInterrupt(String reason) {
        this.tx.connection().terminateAndRelease(reason);
    }
}

