/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.shaded.reactor.core.publisher;

import java.util.ArrayDeque;
import org.neo4j.driver.internal.shaded.reactor.core.CoreSubscriber;
import org.neo4j.driver.internal.shaded.reactor.core.Scannable;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Flux;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.FluxOperator;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.InnerOperator;
import org.neo4j.driver.internal.shaded.reactor.core.publisher.Operators;
import org.neo4j.driver.internal.shaded.reactor.util.annotation.Nullable;
import org.reactivestreams.Subscription;

final class FluxSkipLast<T>
extends FluxOperator<T, T> {
    final int n;

    FluxSkipLast(Flux<? extends T> source, int n) {
        super(source);
        if (n < 0) {
            throw new IllegalArgumentException("n >= 0 required but it was " + n);
        }
        this.n = n;
    }

    @Override
    public void subscribe(CoreSubscriber<? super T> actual) {
        this.source.subscribe(new SkipLastSubscriber<T>(actual, this.n));
    }

    static final class SkipLastSubscriber<T>
    extends ArrayDeque<T>
    implements InnerOperator<T, T> {
        final CoreSubscriber<? super T> actual;
        final int n;
        Subscription s;

        SkipLastSubscriber(CoreSubscriber<? super T> actual, int n) {
            this.actual = actual;
            this.n = n;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (Operators.validate(this.s, s)) {
                this.s = s;
                this.actual.onSubscribe(this);
                s.request((long)this.n);
            }
        }

        public void onNext(T t) {
            if (this.size() == this.n) {
                this.actual.onNext(this.pollFirst());
            }
            this.offerLast(t);
        }

        public void onError(Throwable t) {
            this.actual.onError(t);
            Operators.onDiscardQueueWithClear(this, this.actual.currentContext(), null);
        }

        public void onComplete() {
            this.actual.onComplete();
            Operators.onDiscardQueueWithClear(this, this.actual.currentContext(), null);
        }

        @Override
        @Nullable
        public Object scanUnsafe(Scannable.Attr key) {
            if (key == Scannable.Attr.PARENT) {
                return this.s;
            }
            if (key == Scannable.Attr.PREFETCH) {
                return this.n;
            }
            if (key == Scannable.Attr.BUFFERED) {
                return this.size();
            }
            return InnerOperator.super.scanUnsafe(key);
        }

        @Override
        public CoreSubscriber<? super T> actual() {
            return this.actual;
        }

        public void request(long n) {
            this.s.request(n);
        }

        public void cancel() {
            this.s.cancel();
            Operators.onDiscardQueueWithClear(this, this.actual.currentContext(), null);
        }
    }
}

