/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers.pulln;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.neo4j.driver.Record;
import org.neo4j.driver.Statement;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.InternalRecord;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.BasicPullResponseHandler;
import org.neo4j.driver.internal.messaging.request.DiscardMessage;
import org.neo4j.driver.internal.messaging.request.PullMessage;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.MetadataExtractor;
import org.neo4j.driver.internal.value.BooleanValue;
import org.neo4j.driver.summary.ResultSummary;

public abstract class AbstractBasicPullResponseHandler
implements BasicPullResponseHandler {
    public static final BiConsumer<Record, Throwable> DISCARD_RECORD_CONSUMER = (record, throwable) -> {};
    private final Statement statement;
    protected final RunResponseHandler runResponseHandler;
    protected final MetadataExtractor metadataExtractor;
    protected final Connection connection;
    private BasicPullResponseHandler.Status status = BasicPullResponseHandler.Status.READY;
    private long toRequest;
    private BiConsumer<Record, Throwable> recordConsumer = null;
    private BiConsumer<ResultSummary, Throwable> summaryConsumer = null;

    protected abstract void afterSuccess(Map<String, Value> var1);

    protected abstract void afterFailure(Throwable var1);

    public AbstractBasicPullResponseHandler(Statement statement, RunResponseHandler runResponseHandler, Connection connection, MetadataExtractor metadataExtractor) {
        this.statement = Objects.requireNonNull(statement);
        this.runResponseHandler = Objects.requireNonNull(runResponseHandler);
        this.metadataExtractor = Objects.requireNonNull(metadataExtractor);
        this.connection = Objects.requireNonNull(connection);
    }

    @Override
    public synchronized void onSuccess(Map<String, Value> metadata) {
        this.assertRecordAndSummaryConsumerInstalled();
        if (metadata.getOrDefault("has_more", BooleanValue.FALSE).asBoolean()) {
            this.handleSuccessWithHasMore();
        } else {
            this.handleSuccessWithSummary(metadata);
        }
    }

    @Override
    public synchronized void onFailure(Throwable error) {
        this.assertRecordAndSummaryConsumerInstalled();
        this.status = BasicPullResponseHandler.Status.FAILED;
        this.afterFailure(error);
        this.complete(this.extractResultSummary(Collections.emptyMap()), error);
    }

    @Override
    public synchronized void onRecord(Value[] fields) {
        this.assertRecordAndSummaryConsumerInstalled();
        if (this.isStreaming()) {
            InternalRecord record = new InternalRecord(this.runResponseHandler.statementKeys(), fields);
            this.recordConsumer.accept(record, null);
        }
    }

    public synchronized void request(long size) {
        this.assertRecordAndSummaryConsumerInstalled();
        if (this.isStreamingPaused()) {
            this.connection.writeAndFlush(new PullMessage(size, this.runResponseHandler.statementId()), this);
            this.status = BasicPullResponseHandler.Status.STREAMING;
        } else if (this.isStreaming()) {
            this.addToRequest(size);
        }
    }

    public synchronized void cancel() {
        this.assertRecordAndSummaryConsumerInstalled();
        if (this.isStreamingPaused()) {
            this.connection.writeAndFlush(DiscardMessage.newDiscardAllMessage(this.runResponseHandler.statementId()), this);
            this.status = BasicPullResponseHandler.Status.CANCELED;
        } else if (this.isStreaming()) {
            this.status = BasicPullResponseHandler.Status.CANCELED;
        }
    }

    @Override
    public synchronized void installSummaryConsumer(BiConsumer<ResultSummary, Throwable> summaryConsumer) {
        if (this.summaryConsumer != null) {
            throw new IllegalStateException("Summary consumer already installed.");
        }
        this.summaryConsumer = summaryConsumer;
    }

    @Override
    public synchronized void installRecordConsumer(BiConsumer<Record, Throwable> recordConsumer) {
        if (this.recordConsumer != null) {
            throw new IllegalStateException("Record consumer already installed.");
        }
        this.recordConsumer = recordConsumer;
    }

    private boolean isStreaming() {
        return this.status == BasicPullResponseHandler.Status.STREAMING;
    }

    private boolean isStreamingPaused() {
        return this.status == BasicPullResponseHandler.Status.READY;
    }

    private boolean isFinished() {
        return this.status == BasicPullResponseHandler.Status.DONE || this.status == BasicPullResponseHandler.Status.FAILED;
    }

    private void handleSuccessWithSummary(Map<String, Value> metadata) {
        this.status = BasicPullResponseHandler.Status.DONE;
        this.afterSuccess(metadata);
        ResultSummary summary = this.extractResultSummary(metadata);
        this.complete(summary, null);
    }

    private void handleSuccessWithHasMore() {
        if (this.status == BasicPullResponseHandler.Status.CANCELED) {
            this.status = BasicPullResponseHandler.Status.READY;
            this.cancel();
        } else if (this.status == BasicPullResponseHandler.Status.STREAMING) {
            this.status = BasicPullResponseHandler.Status.READY;
            if (this.toRequest > 0L) {
                this.request(this.toRequest);
                this.toRequest = 0L;
            }
            this.summaryConsumer.accept(null, null);
        }
    }

    private ResultSummary extractResultSummary(Map<String, Value> metadata) {
        long resultAvailableAfter = this.runResponseHandler.resultAvailableAfter();
        return this.metadataExtractor.extractSummary(this.statement, this.connection, resultAvailableAfter, metadata);
    }

    private void addToRequest(long toAdd) {
        if (toAdd <= 0L) {
            throw new IllegalArgumentException("Cannot request record amount that is less than or equal to 0. Request amount: " + toAdd);
        }
        this.toRequest += toAdd;
        if (this.toRequest <= 0L) {
            this.toRequest = Long.MAX_VALUE;
        }
    }

    private void assertRecordAndSummaryConsumerInstalled() {
        if (this.isFinished()) {
            return;
        }
        if (this.recordConsumer == null || this.summaryConsumer == null) {
            throw new IllegalStateException(String.format("Access record stream without record consumer and/or summary consumer. Record consumer=%s, Summary consumer=%s", this.recordConsumer, this.summaryConsumer));
        }
    }

    private void complete(ResultSummary summary, Throwable error) {
        if (this.recordConsumer == DISCARD_RECORD_CONSUMER) {
            this.summaryConsumer.accept(summary, error);
        } else {
            this.summaryConsumer.accept(summary, null);
        }
        this.recordConsumer.accept(null, error);
        this.dispose();
    }

    private void dispose() {
        this.recordConsumer = null;
        this.summaryConsumer = null;
    }

    protected BasicPullResponseHandler.Status status() {
        return this.status;
    }

    protected void status(BasicPullResponseHandler.Status status) {
        this.status = status;
    }
}

