/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cursor;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import org.neo4j.driver.Record;
import org.neo4j.driver.internal.FailableCursor;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.AbstractBasicPullResponseHandler;
import org.neo4j.driver.internal.handlers.pulln.BasicPullResponseHandler;
import org.neo4j.driver.summary.ResultSummary;
import org.reactivestreams.Subscription;

public class RxStatementResultCursor
implements Subscription,
FailableCursor {
    private final RunResponseHandler runHandler;
    private final BasicPullResponseHandler pullHandler;
    private final Throwable runResponseError;
    private final CompletableFuture<ResultSummary> summaryFuture = new CompletableFuture();
    private boolean isRecordHandlerInstalled = false;

    public RxStatementResultCursor(RunResponseHandler runHandler, BasicPullResponseHandler pullHandler) {
        this(null, runHandler, pullHandler);
    }

    public RxStatementResultCursor(Throwable runError, RunResponseHandler runHandler, BasicPullResponseHandler pullHandler) {
        Objects.requireNonNull(runHandler);
        Objects.requireNonNull(pullHandler);
        this.assertRunResponseArrived(runHandler);
        this.runResponseError = runError;
        this.runHandler = runHandler;
        this.pullHandler = pullHandler;
        this.installSummaryConsumer();
    }

    public List<String> keys() {
        return this.runHandler.statementKeys();
    }

    public void installRecordConsumer(BiConsumer<Record, Throwable> recordConsumer) {
        if (this.isRecordHandlerInstalled) {
            return;
        }
        this.isRecordHandlerInstalled = true;
        this.pullHandler.installRecordConsumer(recordConsumer);
        this.assertRunCompletedSuccessfully();
    }

    public void request(long n) {
        this.pullHandler.request(n);
    }

    public void cancel() {
        this.pullHandler.cancel();
    }

    @Override
    public CompletionStage<Throwable> failureAsync() {
        return this.summaryAsync().thenApply(summary -> null).exceptionally(error -> error);
    }

    public CompletionStage<ResultSummary> summaryAsync() {
        if (!this.isDone()) {
            this.installRecordConsumer(AbstractBasicPullResponseHandler.DISCARD_RECORD_CONSUMER);
            this.cancel();
        }
        return this.summaryFuture;
    }

    public boolean isDone() {
        return this.summaryFuture.isDone();
    }

    private void assertRunCompletedSuccessfully() {
        if (this.runResponseError != null) {
            this.pullHandler.onFailure(this.runResponseError);
        }
    }

    private void installSummaryConsumer() {
        this.pullHandler.installSummaryConsumer((summary, error) -> {
            if (error != null) {
                this.summaryFuture.completeExceptionally((Throwable)error);
            } else if (summary != null) {
                this.summaryFuture.complete((ResultSummary)summary);
            }
        });
    }

    private void assertRunResponseArrived(RunResponseHandler runHandler) {
        if (!runHandler.runFuture().isDone()) {
            throw new IllegalStateException("Should wait for response of RUN before allowing PULL.");
        }
    }
}

