/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.Objects;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Statement;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.ReadOnlyBookmarkHolder;
import org.neo4j.driver.internal.async.connection.DirectConnection;
import org.neo4j.driver.internal.cluster.RoutingContext;
import org.neo4j.driver.internal.cluster.RoutingProcedureRunner;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.ServerVersion;

public class MultiDatabasesRoutingProcedureRunner
extends RoutingProcedureRunner {
    static final String DATABASE_NAME = "database";
    static final String MULTI_DB_GET_ROUTING_TABLE = String.format("CALL dbms.routing.getRoutingTable($%s, $%s)", "context", "database");

    public MultiDatabasesRoutingProcedureRunner(RoutingContext context) {
        super(context);
    }

    @Override
    BookmarkHolder bookmarkHolder(InternalBookmark bookmark) {
        return new ReadOnlyBookmarkHolder(bookmark);
    }

    @Override
    Statement procedureStatement(ServerVersion serverVersion, String databaseName) {
        if (Objects.equals("", databaseName)) {
            databaseName = null;
        }
        return new Statement(MULTI_DB_GET_ROUTING_TABLE, Values.parameters("context", this.context.asMap(), DATABASE_NAME, databaseName));
    }

    @Override
    DirectConnection connection(Connection connection) {
        return new DirectConnection(connection, "system", AccessMode.READ);
    }
}

