/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Logger;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.cluster.ClusterRoutingTable;
import org.neo4j.driver.internal.cluster.Rediscovery;
import org.neo4j.driver.internal.cluster.RoutingTableHandler;
import org.neo4j.driver.internal.cluster.RoutingTableRegistry;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.util.Clock;

public class RoutingTableRegistryImpl
implements RoutingTableRegistry {
    private final ConcurrentMap<String, RoutingTableHandler> routingTableHandlers;
    private final RoutingTableHandlerFactory factory;
    private final Logger logger;

    public RoutingTableRegistryImpl(ConnectionPool connectionPool, Rediscovery rediscovery, Clock clock, Logger logger) {
        this(new ConcurrentHashMap<String, RoutingTableHandler>(), new RoutingTableHandlerFactory(connectionPool, rediscovery, clock, logger), logger);
    }

    RoutingTableRegistryImpl(ConcurrentMap<String, RoutingTableHandler> routingTableHandlers, RoutingTableHandlerFactory factory, Logger logger) {
        this.factory = factory;
        this.routingTableHandlers = routingTableHandlers;
        this.logger = logger;
    }

    @Override
    public CompletionStage<RoutingTableHandler> refreshRoutingTable(String databaseName, AccessMode mode) {
        RoutingTableHandler handler = this.getOrCreate(databaseName);
        return handler.refreshRoutingTable(mode).thenApply(ignored -> handler);
    }

    @Override
    public Set<BoltServerAddress> allServers() {
        HashSet<BoltServerAddress> servers = new HashSet<BoltServerAddress>();
        for (RoutingTableHandler tableHandler : this.routingTableHandlers.values()) {
            servers.addAll(tableHandler.servers());
        }
        return servers;
    }

    @Override
    public void remove(String databaseName) {
        this.routingTableHandlers.remove(databaseName);
        this.logger.debug("Routing table handler for database '%s' is removed.", databaseName);
    }

    @Override
    public void purgeAged() {
        this.routingTableHandlers.forEach((databaseName, handler) -> {
            if (handler.isRoutingTableAged()) {
                this.logger.info("Routing table handler for database '%s' is removed because it has not been used for a long time. Routing table: %s", databaseName, handler.routingTable());
                this.routingTableHandlers.remove(databaseName);
            }
        });
    }

    public boolean contains(String databaseName) {
        return this.routingTableHandlers.containsKey(databaseName);
    }

    private RoutingTableHandler getOrCreate(String databaseName) {
        return this.routingTableHandlers.computeIfAbsent(databaseName, name -> {
            RoutingTableHandler handler = this.factory.newInstance((String)name, this);
            this.logger.debug("Routing table handler for database '%s' is added.", databaseName);
            return handler;
        });
    }

    static class RoutingTableHandlerFactory {
        private final ConnectionPool connectionPool;
        private final Rediscovery rediscovery;
        private final Logger log;
        private final Clock clock;

        RoutingTableHandlerFactory(ConnectionPool connectionPool, Rediscovery rediscovery, Clock clock, Logger log) {
            this.connectionPool = connectionPool;
            this.rediscovery = rediscovery;
            this.clock = clock;
            this.log = log;
        }

        RoutingTableHandler newInstance(String databaseName, RoutingTableRegistry allTables) {
            ClusterRoutingTable routingTable = new ClusterRoutingTable(databaseName, this.clock, new BoltServerAddress[0]);
            return new RoutingTableHandler(routingTable, this.rediscovery, this.connectionPool, allTables, this.log);
        }
    }
}

