/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.neo4j.driver.Statement;
import org.neo4j.driver.Value;
import org.neo4j.driver.exceptions.UntrustedServerException;
import org.neo4j.driver.internal.Bookmarks;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.summary.InternalDatabaseInfo;
import org.neo4j.driver.internal.summary.InternalNotification;
import org.neo4j.driver.internal.summary.InternalPlan;
import org.neo4j.driver.internal.summary.InternalProfiledPlan;
import org.neo4j.driver.internal.summary.InternalResultSummary;
import org.neo4j.driver.internal.summary.InternalServerInfo;
import org.neo4j.driver.internal.summary.InternalSummaryCounters;
import org.neo4j.driver.internal.types.InternalTypeSystem;
import org.neo4j.driver.internal.util.ServerVersion;
import org.neo4j.driver.summary.DatabaseInfo;
import org.neo4j.driver.summary.Notification;
import org.neo4j.driver.summary.Plan;
import org.neo4j.driver.summary.ProfiledPlan;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.summary.StatementType;

public class MetadataExtractor {
    public static final int ABSENT_QUERY_ID = -1;
    private final String resultAvailableAfterMetadataKey;
    private final String resultConsumedAfterMetadataKey;

    public MetadataExtractor(String resultAvailableAfterMetadataKey, String resultConsumedAfterMetadataKey) {
        this.resultAvailableAfterMetadataKey = resultAvailableAfterMetadataKey;
        this.resultConsumedAfterMetadataKey = resultConsumedAfterMetadataKey;
    }

    public List<String> extractStatementKeys(Map<String, Value> metadata) {
        Value keysValue = metadata.get("fields");
        if (keysValue != null && !keysValue.isEmpty()) {
            ArrayList<String> keys = new ArrayList<String>(keysValue.size());
            for (Value value : keysValue.values()) {
                keys.add(value.asString());
            }
            return keys;
        }
        return Collections.emptyList();
    }

    public long extractQueryId(Map<String, Value> metadata) {
        Value statementId = metadata.get("qid");
        if (statementId != null) {
            return statementId.asLong();
        }
        return -1L;
    }

    public long extractResultAvailableAfter(Map<String, Value> metadata) {
        Value resultAvailableAfterValue = metadata.get(this.resultAvailableAfterMetadataKey);
        if (resultAvailableAfterValue != null) {
            return resultAvailableAfterValue.asLong();
        }
        return -1L;
    }

    public ResultSummary extractSummary(Statement statement, Connection connection, long resultAvailableAfter, Map<String, Value> metadata) {
        InternalServerInfo serverInfo = new InternalServerInfo(connection.serverAddress(), connection.serverVersion());
        DatabaseInfo dbInfo = MetadataExtractor.extractDatabaseInfo(metadata);
        return new InternalResultSummary(statement, serverInfo, dbInfo, MetadataExtractor.extractStatementType(metadata), MetadataExtractor.extractCounters(metadata), MetadataExtractor.extractPlan(metadata), MetadataExtractor.extractProfiledPlan(metadata), MetadataExtractor.extractNotifications(metadata), resultAvailableAfter, MetadataExtractor.extractResultConsumedAfter(metadata, this.resultConsumedAfterMetadataKey));
    }

    public static DatabaseInfo extractDatabaseInfo(Map<String, Value> metadata) {
        Value dbValue = metadata.get("db");
        if (dbValue == null || dbValue.isNull()) {
            return InternalDatabaseInfo.DEFAULT_DATABASE_INFO;
        }
        return new InternalDatabaseInfo(dbValue.asString());
    }

    public static Bookmarks extractBookmarks(Map<String, Value> metadata) {
        Value bookmarkValue = metadata.get("bookmark");
        if (bookmarkValue != null && !bookmarkValue.isNull() && bookmarkValue.hasType(InternalTypeSystem.TYPE_SYSTEM.STRING())) {
            return Bookmarks.from(bookmarkValue.asString());
        }
        return Bookmarks.empty();
    }

    public static ServerVersion extractNeo4jServerVersion(Map<String, Value> metadata) {
        Value versionValue = metadata.get("server");
        if (versionValue == null || versionValue.isNull()) {
            throw new UntrustedServerException("Server provides no product identifier");
        }
        ServerVersion server = ServerVersion.version(versionValue.asString());
        if ("Neo4j".equalsIgnoreCase(server.product())) {
            return server;
        }
        throw new UntrustedServerException("Server does not identify as a genuine Neo4j instance: '" + server.product() + "'");
    }

    private static StatementType extractStatementType(Map<String, Value> metadata) {
        Value typeValue = metadata.get("type");
        if (typeValue != null) {
            return StatementType.fromCode(typeValue.asString());
        }
        return null;
    }

    private static InternalSummaryCounters extractCounters(Map<String, Value> metadata) {
        Value countersValue = metadata.get("stats");
        if (countersValue != null) {
            return new InternalSummaryCounters(MetadataExtractor.counterValue(countersValue, "nodes-created"), MetadataExtractor.counterValue(countersValue, "nodes-deleted"), MetadataExtractor.counterValue(countersValue, "relationships-created"), MetadataExtractor.counterValue(countersValue, "relationships-deleted"), MetadataExtractor.counterValue(countersValue, "properties-set"), MetadataExtractor.counterValue(countersValue, "labels-added"), MetadataExtractor.counterValue(countersValue, "labels-removed"), MetadataExtractor.counterValue(countersValue, "indexes-added"), MetadataExtractor.counterValue(countersValue, "indexes-removed"), MetadataExtractor.counterValue(countersValue, "constraints-added"), MetadataExtractor.counterValue(countersValue, "constraints-removed"));
        }
        return null;
    }

    private static int counterValue(Value countersValue, String name) {
        Value value = countersValue.get(name);
        return value.isNull() ? 0 : value.asInt();
    }

    private static Plan extractPlan(Map<String, Value> metadata) {
        Value planValue = metadata.get("plan");
        if (planValue != null) {
            return InternalPlan.EXPLAIN_PLAN_FROM_VALUE.apply(planValue);
        }
        return null;
    }

    private static ProfiledPlan extractProfiledPlan(Map<String, Value> metadata) {
        Value profiledPlanValue = metadata.get("profile");
        if (profiledPlanValue != null) {
            return InternalProfiledPlan.PROFILED_PLAN_FROM_VALUE.apply(profiledPlanValue);
        }
        return null;
    }

    private static List<Notification> extractNotifications(Map<String, Value> metadata) {
        Value notificationsValue = metadata.get("notifications");
        if (notificationsValue != null) {
            return notificationsValue.asList(InternalNotification.VALUE_TO_NOTIFICATION);
        }
        return Collections.emptyList();
    }

    private static long extractResultConsumedAfter(Map<String, Value> metadata, String key) {
        Value resultConsumedAfterValue = metadata.get(key);
        if (resultConsumedAfterValue != null) {
            return resultConsumedAfterValue.asLong();
        }
        return -1L;
    }
}

