/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.metrics;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.driver.ConnectionPoolMetrics;
import org.neo4j.driver.Metrics;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.pool.ConnectionPoolImpl;
import org.neo4j.driver.internal.metrics.ConnectionPoolMetricsListener;
import org.neo4j.driver.internal.metrics.InternalAbstractMetrics;
import org.neo4j.driver.internal.metrics.InternalConnectionPoolMetrics;
import org.neo4j.driver.internal.metrics.ListenerEvent;
import org.neo4j.driver.internal.metrics.SnapshotMetrics;
import org.neo4j.driver.internal.metrics.TimeRecorderListenerEvent;
import org.neo4j.driver.internal.util.Clock;

public class InternalMetrics
extends InternalAbstractMetrics {
    private final Map<String, ConnectionPoolMetrics> connectionPoolMetrics;
    private final Clock clock;

    public InternalMetrics(Clock clock) {
        Objects.requireNonNull(clock);
        this.connectionPoolMetrics = new ConcurrentHashMap<String, ConnectionPoolMetrics>();
        this.clock = clock;
    }

    @Override
    public void putPoolMetrics(BoltServerAddress serverAddress, ConnectionPoolImpl pool) {
        this.connectionPoolMetrics.put(InternalMetrics.serverAddressToUniqueName(serverAddress), new InternalConnectionPoolMetrics(serverAddress, pool));
    }

    @Override
    public void beforeCreating(BoltServerAddress serverAddress, ListenerEvent creatingEvent) {
        this.poolMetrics(serverAddress).beforeCreating(creatingEvent);
    }

    @Override
    public void afterCreated(BoltServerAddress serverAddress, ListenerEvent creatingEvent) {
        this.poolMetrics(serverAddress).afterCreated(creatingEvent);
    }

    @Override
    public void afterFailedToCreate(BoltServerAddress serverAddress) {
        this.poolMetrics(serverAddress).afterFailedToCreate();
    }

    @Override
    public void afterClosed(BoltServerAddress serverAddress) {
        this.poolMetrics(serverAddress).afterClosed();
    }

    @Override
    public void beforeAcquiringOrCreating(BoltServerAddress serverAddress, ListenerEvent acquireEvent) {
        this.poolMetrics(serverAddress).beforeAcquiringOrCreating(acquireEvent);
    }

    @Override
    public void afterAcquiringOrCreating(BoltServerAddress serverAddress) {
        this.poolMetrics(serverAddress).afterAcquiringOrCreating();
    }

    @Override
    public void afterAcquiredOrCreated(BoltServerAddress serverAddress, ListenerEvent acquireEvent) {
        this.poolMetrics(serverAddress).afterAcquiredOrCreated(acquireEvent);
    }

    @Override
    public void afterConnectionCreated(BoltServerAddress serverAddress, ListenerEvent inUseEvent) {
        this.poolMetrics(serverAddress).acquired(inUseEvent);
    }

    @Override
    public void afterConnectionReleased(BoltServerAddress serverAddress, ListenerEvent inUseEvent) {
        this.poolMetrics(serverAddress).released(inUseEvent);
    }

    @Override
    public void afterTimedOutToAcquireOrCreate(BoltServerAddress serverAddress) {
        this.poolMetrics(serverAddress).afterTimedOutToAcquireOrCreate();
    }

    @Override
    public ListenerEvent createListenerEvent() {
        return new TimeRecorderListenerEvent(this.clock);
    }

    @Override
    public Map<String, ConnectionPoolMetrics> connectionPoolMetrics() {
        return Collections.unmodifiableMap(this.connectionPoolMetrics);
    }

    @Override
    public Metrics snapshot() {
        return new SnapshotMetrics(this);
    }

    public String toString() {
        return String.format("PoolMetrics=%s", this.connectionPoolMetrics);
    }

    static String serverAddressToUniqueName(BoltServerAddress serverAddress) {
        return String.format("%s:%d", serverAddress.host(), serverAddress.port());
    }

    private ConnectionPoolMetricsListener poolMetrics(BoltServerAddress serverAddress) {
        InternalConnectionPoolMetrics poolMetrics = (InternalConnectionPoolMetrics)this.connectionPoolMetrics.get(InternalMetrics.serverAddressToUniqueName(serverAddress));
        if (poolMetrics == null) {
            throw new ClientException(String.format("Failed to find pool metrics for server `%s` in %s", serverAddress, this.connectionPoolMetrics));
        }
        return poolMetrics;
    }
}

