/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.metrics;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.driver.ConnectionPoolMetrics;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.metrics.ConnectionPoolMetricsListener;
import org.neo4j.driver.internal.metrics.InternalMetrics;
import org.neo4j.driver.internal.metrics.ListenerEvent;
import org.neo4j.driver.internal.metrics.SnapshotConnectionPoolMetrics;
import org.neo4j.driver.internal.spi.ConnectionPool;

public class InternalConnectionPoolMetrics
implements ConnectionPoolMetrics,
ConnectionPoolMetricsListener {
    private final BoltServerAddress address;
    private final ConnectionPool pool;
    private final AtomicLong closed = new AtomicLong();
    private final AtomicInteger creating = new AtomicInteger();
    private final AtomicLong created = new AtomicLong();
    private final AtomicLong failedToCreate = new AtomicLong();
    private final AtomicInteger acquiring = new AtomicInteger();
    private final AtomicLong acquired = new AtomicLong();
    private final AtomicLong timedOutToAcquire = new AtomicLong();
    private final AtomicLong totalAcquisitionTime = new AtomicLong();
    private final AtomicLong totalConnectionTime = new AtomicLong();
    private final AtomicLong totalInUseTime = new AtomicLong();
    private final AtomicLong totalInUseCount = new AtomicLong();

    public InternalConnectionPoolMetrics(BoltServerAddress address, ConnectionPool pool) {
        Objects.requireNonNull(address);
        Objects.requireNonNull(pool);
        this.address = address;
        this.pool = pool;
    }

    @Override
    public void beforeCreating(ListenerEvent connEvent) {
        this.creating.incrementAndGet();
        connEvent.start();
    }

    @Override
    public void afterFailedToCreate() {
        this.failedToCreate.incrementAndGet();
        this.creating.decrementAndGet();
    }

    @Override
    public void afterCreated(ListenerEvent connEvent) {
        this.created.incrementAndGet();
        this.creating.decrementAndGet();
        long elapsed = connEvent.elapsed();
        this.totalConnectionTime.addAndGet(elapsed);
    }

    @Override
    public void afterClosed() {
        this.closed.incrementAndGet();
    }

    @Override
    public void beforeAcquiringOrCreating(ListenerEvent acquireEvent) {
        acquireEvent.start();
        this.acquiring.incrementAndGet();
    }

    @Override
    public void afterAcquiringOrCreating() {
        this.acquiring.decrementAndGet();
    }

    @Override
    public void afterAcquiredOrCreated(ListenerEvent acquireEvent) {
        this.acquired.incrementAndGet();
        long elapsed = acquireEvent.elapsed();
        this.totalAcquisitionTime.addAndGet(elapsed);
    }

    @Override
    public void afterTimedOutToAcquireOrCreate() {
        this.timedOutToAcquire.incrementAndGet();
    }

    @Override
    public void acquired(ListenerEvent inUseEvent) {
        inUseEvent.start();
    }

    @Override
    public void released(ListenerEvent inUseEvent) {
        this.totalInUseCount.incrementAndGet();
        long elapsed = inUseEvent.elapsed();
        this.totalInUseTime.addAndGet(elapsed);
    }

    @Override
    public String id() {
        return InternalMetrics.serverAddressToUniqueName(this.address);
    }

    @Override
    public ConnectionPoolMetrics.PoolStatus poolStatus() {
        if (this.pool.isOpen(this.address)) {
            return ConnectionPoolMetrics.PoolStatus.OPEN;
        }
        return ConnectionPoolMetrics.PoolStatus.CLOSED;
    }

    @Override
    public int inUse() {
        return this.pool.inUseConnections(this.address);
    }

    @Override
    public int idle() {
        return this.pool.idleConnections(this.address);
    }

    @Override
    public int creating() {
        return this.creating.get();
    }

    @Override
    public long created() {
        return this.created.get();
    }

    @Override
    public long failedToCreate() {
        return this.failedToCreate.get();
    }

    @Override
    public long timedOutToAcquire() {
        return this.timedOutToAcquire.get();
    }

    @Override
    public long totalAcquisitionTime() {
        return this.totalAcquisitionTime.get();
    }

    @Override
    public long totalConnectionTime() {
        return this.totalConnectionTime.get();
    }

    @Override
    public long totalInUseTime() {
        return this.totalInUseTime.get();
    }

    @Override
    public long totalInUseCount() {
        return this.totalInUseCount.get();
    }

    @Override
    public ConnectionPoolMetrics snapshot() {
        return new SnapshotConnectionPoolMetrics(this);
    }

    @Override
    public long closed() {
        return this.closed.get();
    }

    @Override
    public int acquiring() {
        return this.acquiring.get();
    }

    @Override
    public long acquired() {
        return this.acquired.get();
    }

    public String toString() {
        return String.format("[created=%s, closed=%s, creating=%s, failedToCreate=%s, acquiring=%s, acquired=%s, timedOutToAcquire=%s, inUse=%s, idle=%s, poolStatus=%s, totalAcquisitionTime=%s, totalConnectionTime=%s, totalInUseTime=%s, totalInUseCount=%s]", new Object[]{this.created(), this.closed(), this.creating(), this.failedToCreate(), this.acquiring(), this.acquired(), this.timedOutToAcquire(), this.inUse(), this.idle(), this.poolStatus(), this.totalAcquisitionTime(), this.totalConnectionTime(), this.totalInUseTime(), this.totalInUseCount()});
    }
}

