/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.concurrent.CompletionStage;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.async.connection.DecoratedConnection;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.spi.ConnectionProvider;

public class DirectConnectionProvider
implements ConnectionProvider {
    private final BoltServerAddress address;
    private final ConnectionPool connectionPool;

    DirectConnectionProvider(BoltServerAddress address, ConnectionPool connectionPool) {
        this.address = address;
        this.connectionPool = connectionPool;
    }

    @Override
    public CompletionStage<Connection> acquireConnection(String databaseName, AccessMode mode) {
        return this.connectionPool.acquire(this.address).thenApply(connection -> new DecoratedConnection((Connection)connection, databaseName, mode));
    }

    @Override
    public CompletionStage<Void> verifyConnectivity() {
        return this.acquireConnection("", AccessMode.READ).thenCompose(Connection::release);
    }

    @Override
    public CompletionStage<Void> close() {
        return this.connectionPool.close();
    }

    public BoltServerAddress getAddress() {
        return this.address;
    }
}

