/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import org.neo4j.driver.AuthToken;
import org.neo4j.driver.Session;

public class ConnectionSettings {
    private static final String DEFAULT_USER_AGENT = String.format("neo4j-java/%s", ConnectionSettings.driverVersion());
    private final AuthToken authToken;
    private final String userAgent;
    private final int connectTimeoutMillis;

    private static String driverVersion() {
        Package pkg = Session.class.getPackage();
        if (pkg != null && pkg.getImplementationVersion() != null) {
            return pkg.getImplementationVersion();
        }
        return "dev";
    }

    public ConnectionSettings(AuthToken authToken, String userAgent, int connectTimeoutMillis) {
        this.authToken = authToken;
        this.userAgent = userAgent;
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    public ConnectionSettings(AuthToken authToken, int connectTimeoutMillis) {
        this(authToken, DEFAULT_USER_AGENT, connectTimeoutMillis);
    }

    public AuthToken authToken() {
        return this.authToken;
    }

    public String userAgent() {
        return this.userAgent;
    }

    public int connectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }
}

