/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.reactive;

import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.Statement;
import org.neo4j.driver.internal.ExplicitTransaction;
import org.neo4j.driver.internal.reactive.AbstractRxStatementRunner;
import org.neo4j.driver.internal.reactive.InternalRxResult;
import org.neo4j.driver.internal.reactive.RxUtils;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.reactive.RxResult;
import org.neo4j.driver.reactive.RxTransaction;
import org.reactivestreams.Publisher;

public class InternalRxTransaction
extends AbstractRxStatementRunner
implements RxTransaction {
    private final ExplicitTransaction asyncTx;

    public InternalRxTransaction(ExplicitTransaction asyncTx) {
        this.asyncTx = asyncTx;
    }

    @Override
    public RxResult run(Statement statement) {
        return new InternalRxResult(() -> {
            CompletableFuture cursorFuture = new CompletableFuture();
            this.asyncTx.runRx(statement).whenComplete((cursor, completionError) -> {
                if (cursor != null) {
                    cursorFuture.complete(cursor);
                } else {
                    Throwable error = Futures.completionExceptionCause(completionError);
                    this.asyncTx.markTerminated();
                    cursorFuture.completeExceptionally(error);
                }
            });
            return cursorFuture;
        });
    }

    @Override
    public <T> Publisher<T> commit() {
        return this.close(true);
    }

    @Override
    public <T> Publisher<T> rollback() {
        return this.close(false);
    }

    private <T> Publisher<T> close(boolean commit) {
        return RxUtils.createEmptyPublisher(() -> {
            if (commit) {
                return this.asyncTx.commitAsync();
            }
            return this.asyncTx.rollbackAsync();
        });
    }
}

