/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.spi.ResponseHandler;
import org.neo4j.driver.internal.util.MetadataExtractor;

public class RunResponseHandler
implements ResponseHandler {
    private final CompletableFuture<Throwable> runCompletedFuture;
    private final MetadataExtractor metadataExtractor;
    private long statementId = -1L;
    private List<String> statementKeys = Collections.emptyList();
    private long resultAvailableAfter = -1L;

    public RunResponseHandler(MetadataExtractor metadataExtractor) {
        this(new CompletableFuture<Throwable>(), metadataExtractor);
    }

    public RunResponseHandler(CompletableFuture<Throwable> runCompletedFuture, MetadataExtractor metadataExtractor) {
        this.runCompletedFuture = runCompletedFuture;
        this.metadataExtractor = metadataExtractor;
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        this.statementKeys = this.metadataExtractor.extractStatementKeys(metadata);
        this.resultAvailableAfter = this.metadataExtractor.extractResultAvailableAfter(metadata);
        this.statementId = this.metadataExtractor.extractQueryId(metadata);
        this.completeRunFuture(null);
    }

    @Override
    public void onFailure(Throwable error) {
        this.completeRunFuture(error);
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new UnsupportedOperationException();
    }

    public List<String> statementKeys() {
        return this.statementKeys;
    }

    public long resultAvailableAfter() {
        return this.resultAvailableAfter;
    }

    public long statementId() {
        return this.statementId;
    }

    private void completeRunFuture(Throwable error) {
        this.runCompletedFuture.complete(error);
    }

    public CompletableFuture<Throwable> runFuture() {
        return this.runCompletedFuture;
    }
}

