/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.Values;

public final class Bookmarks {
    private static final String BOOKMARK_KEY = "bookmark";
    private static final String BOOKMARKS_KEY = "bookmarks";
    private static final String BOOKMARK_PREFIX = "neo4j:bookmark:v1:tx";
    private static final long UNKNOWN_BOOKMARK_VALUE = -1L;
    private static final Bookmarks EMPTY = new Bookmarks(Collections.emptySet());
    private final Iterable<String> values;
    private final String maxValue;

    private Bookmarks(Iterable<String> values) {
        this.values = values;
        this.maxValue = Bookmarks.maxBookmark(values);
    }

    public static Bookmarks empty() {
        return EMPTY;
    }

    public static Bookmarks from(String value) {
        if (value == null) {
            return Bookmarks.empty();
        }
        return Bookmarks.from(Collections.singleton(value));
    }

    public static Bookmarks from(Iterable<String> values) {
        if (values == null) {
            return Bookmarks.empty();
        }
        return new Bookmarks(values);
    }

    public boolean isEmpty() {
        return this.maxValue == null;
    }

    public String maxBookmarkAsString() {
        return this.maxValue;
    }

    public Iterable<String> values() {
        return this.values;
    }

    public Map<String, Value> asBeginTransactionParameters() {
        if (this.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Value> parameters = Iterables.newHashMapWithSize(2);
        parameters.put(BOOKMARK_KEY, Values.value(this.maxValue));
        parameters.put(BOOKMARKS_KEY, Values.value(this.values));
        return parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bookmarks bookmarks = (Bookmarks)o;
        return Objects.equals(this.values, bookmarks.values) && Objects.equals(this.maxValue, bookmarks.maxValue);
    }

    public int hashCode() {
        return Objects.hash(this.values, this.maxValue);
    }

    public String toString() {
        return "Bookmarks{values=" + this.values + "}";
    }

    private static String maxBookmark(Iterable<String> bookmarks) {
        if (bookmarks == null) {
            return null;
        }
        Iterator<String> iterator = bookmarks.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        String maxBookmark = iterator.next();
        long maxValue = Bookmarks.bookmarkValue(maxBookmark);
        while (iterator.hasNext()) {
            String bookmark = iterator.next();
            long value = Bookmarks.bookmarkValue(bookmark);
            if (value <= maxValue) continue;
            maxBookmark = bookmark;
            maxValue = value;
        }
        return maxBookmark;
    }

    private static long bookmarkValue(String value) {
        if (value != null && value.startsWith(BOOKMARK_PREFIX)) {
            try {
                return Long.parseLong(value.substring(BOOKMARK_PREFIX.length()));
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
        return -1L;
    }
}

