/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster.loadbalancing;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.internal.RoutingErrorHandler;
import org.neo4j.driver.internal.async.AccessModeConnection;
import org.neo4j.driver.internal.async.RoutingConnection;
import org.neo4j.driver.internal.cluster.AddressSet;
import org.neo4j.driver.internal.cluster.ClusterComposition;
import org.neo4j.driver.internal.cluster.ClusterRoutingTable;
import org.neo4j.driver.internal.cluster.Rediscovery;
import org.neo4j.driver.internal.cluster.RoutingProcedureClusterCompositionProvider;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.cluster.RoutingTable;
import org.neo4j.driver.internal.cluster.loadbalancing.LeastConnectedLoadBalancingStrategy;
import org.neo4j.driver.internal.cluster.loadbalancing.LoadBalancingStrategy;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.EventExecutorGroup;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionPool;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.v1.AccessMode;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.exceptions.ServiceUnavailableException;
import org.neo4j.driver.v1.exceptions.SessionExpiredException;
import org.neo4j.driver.v1.net.ServerAddressResolver;

public class LoadBalancer
implements ConnectionProvider,
RoutingErrorHandler {
    private static final String LOAD_BALANCER_LOG_NAME = "LoadBalancer";
    private final ConnectionPool connectionPool;
    private final RoutingTable routingTable;
    private final Rediscovery rediscovery;
    private final LoadBalancingStrategy loadBalancingStrategy;
    private final EventExecutorGroup eventExecutorGroup;
    private final Logger log;
    private CompletableFuture<RoutingTable> refreshRoutingTableFuture;

    public LoadBalancer(BoltServerAddress initialRouter, RoutingSettings settings, ConnectionPool connectionPool, EventExecutorGroup eventExecutorGroup, Clock clock, Logging logging, LoadBalancingStrategy loadBalancingStrategy, ServerAddressResolver resolver) {
        this(connectionPool, new ClusterRoutingTable(clock, initialRouter), LoadBalancer.createRediscovery(initialRouter, settings, eventExecutorGroup, resolver, clock, logging), LoadBalancer.loadBalancerLogger(logging), loadBalancingStrategy, eventExecutorGroup);
    }

    LoadBalancer(ConnectionPool connectionPool, RoutingTable routingTable, Rediscovery rediscovery, EventExecutorGroup eventExecutorGroup, Logging logging) {
        this(connectionPool, routingTable, rediscovery, LoadBalancer.loadBalancerLogger(logging), new LeastConnectedLoadBalancingStrategy(connectionPool, logging), eventExecutorGroup);
    }

    private LoadBalancer(ConnectionPool connectionPool, RoutingTable routingTable, Rediscovery rediscovery, Logger log, LoadBalancingStrategy loadBalancingStrategy, EventExecutorGroup eventExecutorGroup) {
        this.connectionPool = connectionPool;
        this.routingTable = routingTable;
        this.rediscovery = rediscovery;
        this.loadBalancingStrategy = loadBalancingStrategy;
        this.eventExecutorGroup = eventExecutorGroup;
        this.log = log;
    }

    @Override
    public CompletionStage<Connection> acquireConnection(AccessMode mode) {
        return this.freshRoutingTable(mode).thenCompose(routingTable -> this.acquire(mode, (RoutingTable)routingTable)).thenApply(connection -> new RoutingConnection((Connection)connection, mode, this)).thenApply(connection -> new AccessModeConnection((Connection)connection, mode));
    }

    @Override
    public CompletionStage<Void> verifyConnectivity() {
        return this.freshRoutingTable(AccessMode.READ).thenApply(routingTable -> null);
    }

    @Override
    public void onConnectionFailure(BoltServerAddress address) {
        this.forget(address);
    }

    @Override
    public void onWriteFailure(BoltServerAddress address) {
        this.routingTable.removeWriter(address);
    }

    @Override
    public CompletionStage<Void> close() {
        return this.connectionPool.close();
    }

    private synchronized void forget(BoltServerAddress address) {
        this.routingTable.forget(address);
    }

    private synchronized CompletionStage<RoutingTable> freshRoutingTable(AccessMode mode) {
        if (this.refreshRoutingTableFuture != null) {
            return this.refreshRoutingTableFuture;
        }
        if (this.routingTable.isStaleFor(mode)) {
            this.log.info("Routing table is stale. %s", this.routingTable);
            CompletableFuture<RoutingTable> resultFuture = new CompletableFuture<RoutingTable>();
            this.refreshRoutingTableFuture = resultFuture;
            this.rediscovery.lookupClusterComposition(this.routingTable, this.connectionPool).whenComplete((composition, completionError) -> {
                Throwable error = Futures.completionExceptionCause(completionError);
                if (error != null) {
                    this.clusterCompositionLookupFailed(error);
                } else {
                    this.freshClusterCompositionFetched((ClusterComposition)composition);
                }
            });
            return resultFuture;
        }
        return CompletableFuture.completedFuture(this.routingTable);
    }

    private synchronized void freshClusterCompositionFetched(ClusterComposition composition) {
        try {
            this.routingTable.update(composition);
            this.connectionPool.retainAll(this.routingTable.servers());
            this.log.info("Updated routing table. %s", this.routingTable);
            CompletableFuture<RoutingTable> routingTableFuture = this.refreshRoutingTableFuture;
            this.refreshRoutingTableFuture = null;
            routingTableFuture.complete(this.routingTable);
        }
        catch (Throwable error) {
            this.clusterCompositionLookupFailed(error);
        }
    }

    private synchronized void clusterCompositionLookupFailed(Throwable error) {
        CompletableFuture<RoutingTable> routingTableFuture = this.refreshRoutingTableFuture;
        this.refreshRoutingTableFuture = null;
        routingTableFuture.completeExceptionally(error);
    }

    private CompletionStage<Connection> acquire(AccessMode mode, RoutingTable routingTable) {
        AddressSet addresses = LoadBalancer.addressSet(mode, routingTable);
        CompletableFuture<Connection> result = new CompletableFuture<Connection>();
        this.acquire(mode, addresses, result);
        return result;
    }

    private void acquire(AccessMode mode, AddressSet addresses, CompletableFuture<Connection> result) {
        BoltServerAddress address = this.selectAddress(mode, addresses);
        if (address == null) {
            result.completeExceptionally(new SessionExpiredException("Failed to obtain connection towards " + (Object)((Object)mode) + " server. Known routing table is: " + this.routingTable));
            return;
        }
        this.connectionPool.acquire(address).whenComplete((connection, completionError) -> {
            Throwable error = Futures.completionExceptionCause(completionError);
            if (error != null) {
                if (error instanceof ServiceUnavailableException) {
                    this.log.error("Failed to obtain a connection towards address " + address, error);
                    this.forget(address);
                    this.eventExecutorGroup.next().execute(() -> this.acquire(mode, addresses, result));
                } else {
                    result.completeExceptionally(error);
                }
            } else {
                result.complete((Connection)connection);
            }
        });
    }

    private static AddressSet addressSet(AccessMode mode, RoutingTable routingTable) {
        switch (mode) {
            case READ: {
                return routingTable.readers();
            }
            case WRITE: {
                return routingTable.writers();
            }
        }
        throw LoadBalancer.unknownMode(mode);
    }

    private BoltServerAddress selectAddress(AccessMode mode, AddressSet servers) {
        BoltServerAddress[] addresses = servers.toArray();
        switch (mode) {
            case READ: {
                return this.loadBalancingStrategy.selectReader(addresses);
            }
            case WRITE: {
                return this.loadBalancingStrategy.selectWriter(addresses);
            }
        }
        throw LoadBalancer.unknownMode(mode);
    }

    private static Rediscovery createRediscovery(BoltServerAddress initialRouter, RoutingSettings settings, EventExecutorGroup eventExecutorGroup, ServerAddressResolver resolver, Clock clock, Logging logging) {
        Logger log = LoadBalancer.loadBalancerLogger(logging);
        RoutingProcedureClusterCompositionProvider clusterCompositionProvider = new RoutingProcedureClusterCompositionProvider(clock, settings);
        return new Rediscovery(initialRouter, settings, clusterCompositionProvider, eventExecutorGroup, resolver, log);
    }

    private static Logger loadBalancerLogger(Logging logging) {
        return logging.getLog(LOAD_BALANCER_LOG_NAME);
    }

    private static RuntimeException unknownMode(AccessMode mode) {
        return new IllegalArgumentException("Mode '" + (Object)((Object)mode) + "' is not supported");
    }
}

